/*
 * Decompiled with CFR 0.152.
 */
package cdc.graphs.impl;

import cdc.graphs.api.EdgeDirection;
import cdc.graphs.api.EdgeTip;
import cdc.graphs.api.GraphAdapter;
import cdc.graphs.api.TreeAdapter;
import cdc.graphs.impl.BasicGraphEdge;
import cdc.graphs.impl.GraphEdgeIngoingPredicate;
import cdc.graphs.impl.GraphEdgeOutgoingPredicate;
import cdc.util.function.IterableUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TreeAsGraph<N>
implements GraphAdapter<N, BasicGraphEdge<N>> {
    private final TreeAdapter<N> tree;
    private final Set<N> nodes = new HashSet<N>();
    private final Set<BasicGraphEdge<N>> edges = new HashSet<BasicGraphEdge<N>>();
    private final Map<N, Set<BasicGraphEdge<N>>> nodesToEdges = new HashMap<N, Set<BasicGraphEdge<N>>>();
    private N root = null;

    public TreeAsGraph(TreeAdapter<N> tree) {
        this.tree = tree;
    }

    public void setRoot(N root) {
        this.root = root;
        this.nodes.clear();
        this.edges.clear();
        this.nodesToEdges.clear();
        if (root != null) {
            this.build(root);
        }
    }

    public final N getRoot() {
        return this.root;
    }

    private void build(N node) {
        this.nodes.add(node);
        if (this.tree.hasChildren(node)) {
            HashSet<BasicGraphEdge<N>> tmp = new HashSet<BasicGraphEdge<N>>();
            for (Object child : this.tree.getChildren(node)) {
                BasicGraphEdge<N> edge = new BasicGraphEdge<N>(node, child);
                this.edges.add(edge);
                tmp.add(edge);
            }
            this.nodesToEdges.put(node, tmp);
        }
    }

    public Iterable<? extends N> getNodes() {
        return this.nodes;
    }

    public boolean containsNode(N node) {
        return this.nodes.contains(node);
    }

    public Iterable<? extends BasicGraphEdge<N>> getEdges() {
        return this.edges;
    }

    public boolean containsEdge(BasicGraphEdge<N> edge) {
        return this.edges.contains(edge);
    }

    public Iterable<? extends BasicGraphEdge<N>> getEdges(N node, EdgeDirection direction) {
        Set<BasicGraphEdge<N>> set = this.nodesToEdges.get(node);
        if (direction == null) {
            return set;
        }
        if (direction == EdgeDirection.INGOING) {
            return IterableUtils.filter(set, new GraphEdgeIngoingPredicate<N>(node));
        }
        return IterableUtils.filter(set, new GraphEdgeOutgoingPredicate<N>(node));
    }

    public N getTip(BasicGraphEdge<N> edge, EdgeTip tip) {
        return (N)edge.getTip(tip);
    }
}

