/*
 * Decompiled with CFR 0.152.
 */
package cdc.graphs.impl.tests;

import cdc.graphs.api.GraphAdapter;
import cdc.graphs.impl.tests.TestEdge;
import cdc.graphs.impl.tests.TestNode;
import java.util.HashSet;
import java.util.Set;

public interface TestGraph<N extends TestNode, E extends TestEdge<N>>
extends GraphAdapter<N, E> {
    public static String toNodeName(int number) {
        return "N" + number;
    }

    public static String toEdgeName(int sourceNumber, int targetNumber, String suffix) {
        return "E" + sourceNumber + "-" + targetNumber + suffix;
    }

    public static String toEdgeName(int sourceNumber, int targetNumber) {
        return "E" + sourceNumber + "-" + targetNumber;
    }

    public void clear();

    default public void clearLabels() {
        for (TestNode node : this.getNodes()) {
            node.setLabel(null);
        }
        for (TestEdge edge : this.getEdges()) {
            edge.setLabel(null);
        }
    }

    public Iterable<N> getNodes();

    public N getNode(String var1);

    default public Set<N> getNodes(String ... names) {
        HashSet<N> set = new HashSet<N>();
        for (String name : names) {
            N node = this.getNode(name);
            if (node == null) {
                throw new IllegalArgumentException("Invalid node name:" + name);
            }
            set.add(node);
        }
        return set;
    }

    default public N getNode(int number) {
        return this.getNode(TestGraph.toNodeName(number));
    }

    default public boolean hasNode(String name) {
        return this.getNode(name) != null;
    }

    public N createNode(String var1);

    default public N getOrCreateNode(String name) {
        N node = this.getNode(name);
        if (node == null) {
            node = this.createNode(name);
        }
        return node;
    }

    default public N getOrCreateNode(int number) {
        return this.getOrCreateNode(TestGraph.toNodeName(number));
    }

    public void removeNode(N var1);

    default public void removeNode(String name) {
        this.removeNode(this.getNode(name));
    }

    default public void removeNode(int number) {
        this.removeNode(this.getNode(TestGraph.toNodeName(number)));
    }

    public Iterable<E> getEdges();

    public E getEdge(String var1);

    default public E getEdge(int sourceNumber, int targetNumber) {
        return this.getEdge(TestGraph.toEdgeName(sourceNumber, targetNumber));
    }

    default public boolean hasEdge(String name) {
        return this.getEdge(name) != null;
    }

    public E createEdge(String var1, N var2, N var3);

    default public E getOrCreateEdge(int sourceNumber, int targetNumber) {
        String name = TestGraph.toEdgeName(sourceNumber, targetNumber);
        E edge = this.getEdge(name);
        if (edge == null) {
            N source = this.getOrCreateNode(sourceNumber);
            N target = this.getOrCreateNode(targetNumber);
            edge = this.createEdge(name, source, target);
        }
        return edge;
    }

    default public E getOrCreateEdge(int sourceNumber, int targetNumber, String suffix) {
        String name = TestGraph.toEdgeName(sourceNumber, targetNumber, suffix);
        E edge = this.getEdge(name);
        if (edge == null) {
            N source = this.getOrCreateNode(sourceNumber);
            N target = this.getOrCreateNode(targetNumber);
            edge = this.createEdge(name, source, target);
        }
        return edge;
    }

    public void removeEdge(E var1);

    default public void removeEdge(String name) {
        this.removeEdge(this.getEdge(name));
    }

    default public void removeEdge(int sourceNumber, int targetNumber) {
        this.removeEdge(TestGraph.toEdgeName(sourceNumber, targetNumber));
    }

    default public E createEdge(String name, String sourceName, String targetName) {
        return this.createEdge(name, this.getNode(sourceName), this.getNode(targetName));
    }

    default public E createEdge(String sourceName, String targetName) {
        return this.createEdge(sourceName + "_" + targetName, this.getNode(sourceName), this.getNode(targetName));
    }
}

