/*
 * Decompiled with CFR 0.152.
 */
package cdc.graphs.impl;

import cdc.graphs.EdgeDirection;
import cdc.graphs.EdgeTip;
import cdc.graphs.NodeConnectivity;
import cdc.graphs.impl.BasicGraphHeavyNode;
import cdc.graphs.impl.tests.TestGraphHeavyEdge;
import cdc.graphs.impl.tests.TestGraphHeavyNode;
import cdc.graphs.impl.tests.TestHeavyGraph;
import cdc.util.function.IterableUtils;
import java.util.HashSet;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class GraphBasicQueriesTest {
    GraphBasicQueriesTest() {
    }

    @SafeVarargs
    private static <T> Set<T> set(T ... values) {
        HashSet<T> result = new HashSet<T>();
        for (T value : values) {
            result.add(value);
        }
        return result;
    }

    @Test
    void testBasic() {
        TestHeavyGraph g = new TestHeavyGraph();
        Assertions.assertFalse((boolean)g.hasNodes());
        Assertions.assertFalse((boolean)g.hasEdges());
        TestGraphHeavyNode n1 = g.createNode("N1");
        Assertions.assertTrue((boolean)g.hasNodes());
        Assertions.assertEquals((int)1, (int)g.getNodesCount());
        Assertions.assertFalse((boolean)g.hasEdges());
        Assertions.assertTrue((boolean)IterableUtils.isEmpty((Iterable)n1.getIngoings()));
        Assertions.assertTrue((boolean)IterableUtils.isEmpty((Iterable)n1.getOutgoings()));
        Assertions.assertTrue((boolean)IterableUtils.isEmpty((Iterable)g.getEdges((Object)n1)));
        Assertions.assertTrue((boolean)IterableUtils.isEmpty((Iterable)g.getEdges((BasicGraphHeavyNode)n1, EdgeDirection.OUTGOING)));
        Assertions.assertTrue((boolean)IterableUtils.isEmpty((Iterable)g.getEdges((BasicGraphHeavyNode)n1, EdgeDirection.INGOING)));
        Assertions.assertTrue((boolean)IterableUtils.isEmpty((Iterable)g.getConnectedNodes((Object)n1)));
        Assertions.assertTrue((boolean)IterableUtils.isEmpty((Iterable)g.getConnectedNodes((Object)n1, EdgeDirection.OUTGOING)));
        Assertions.assertTrue((boolean)IterableUtils.isEmpty((Iterable)g.getConnectedNodes((Object)n1, EdgeDirection.INGOING)));
        Assertions.assertFalse((boolean)g.hasEdges((Object)n1, null));
        Assertions.assertFalse((boolean)g.hasEdges((Object)n1, EdgeDirection.OUTGOING));
        Assertions.assertFalse((boolean)g.hasEdges((Object)n1, EdgeDirection.INGOING));
        Assertions.assertFalse((boolean)g.hasEdge((Object)n1, (Object)n1));
        Assertions.assertTrue((boolean)g.hasNode("N1"));
        Assertions.assertFalse((boolean)g.hasNode("N2"));
        TestGraphHeavyNode n2 = g.createNode("N2");
        Assertions.assertTrue((boolean)g.hasNodes());
        Assertions.assertEquals((int)2, (int)g.getNodesCount());
        Assertions.assertFalse((boolean)g.hasEdges());
        Assertions.assertTrue((boolean)IterableUtils.isEmpty((Iterable)n2.getIngoings()));
        Assertions.assertTrue((boolean)IterableUtils.isEmpty((Iterable)n2.getOutgoings()));
        TestGraphHeavyEdge e12 = (TestGraphHeavyEdge)g.createEdge("E12", "N1", "N2");
        Assertions.assertTrue((boolean)g.hasNodes());
        Assertions.assertEquals((int)2, (int)g.getNodesCount());
        Assertions.assertTrue((boolean)g.hasEdges());
        Assertions.assertEquals((int)1, (int)g.getEdgesCount());
        Assertions.assertEquals((Object)n1, (Object)e12.getSource());
        Assertions.assertEquals((Object)n2, (Object)e12.getTarget());
        Assertions.assertEquals((int)1, (int)IterableUtils.size((Iterable)n1.getOutgoings()));
        Assertions.assertEquals((int)0, (int)IterableUtils.size((Iterable)n1.getIngoings()));
        Assertions.assertEquals((int)0, (int)IterableUtils.size((Iterable)n2.getOutgoings()));
        Assertions.assertEquals((int)1, (int)IterableUtils.size((Iterable)n2.getIngoings()));
        Assertions.assertEquals((int)1, (int)IterableUtils.size((Iterable)g.getEdges((Object)n1)));
        Assertions.assertEquals((int)1, (int)IterableUtils.size((Iterable)g.getEdges((BasicGraphHeavyNode)n1, EdgeDirection.OUTGOING)));
        Assertions.assertEquals((int)0, (int)IterableUtils.size((Iterable)g.getEdges((BasicGraphHeavyNode)n1, EdgeDirection.INGOING)));
        Assertions.assertEquals((int)1, (int)IterableUtils.size((Iterable)g.getEdges((Object)n2)));
        Assertions.assertEquals((int)0, (int)IterableUtils.size((Iterable)g.getEdges((BasicGraphHeavyNode)n2, EdgeDirection.OUTGOING)));
        Assertions.assertEquals((int)1, (int)IterableUtils.size((Iterable)g.getEdges((BasicGraphHeavyNode)n2, EdgeDirection.INGOING)));
        Assertions.assertEquals((int)1, (int)IterableUtils.size((Iterable)g.getConnectedNodes((Object)n1, null)));
        Assertions.assertEquals((int)1, (int)IterableUtils.size((Iterable)g.getConnectedNodes((Object)n1, EdgeDirection.OUTGOING)));
        Assertions.assertEquals((int)0, (int)IterableUtils.size((Iterable)g.getConnectedNodes((Object)n1, EdgeDirection.INGOING)));
        Assertions.assertEquals((int)1, (int)IterableUtils.size((Iterable)g.getConnectedNodes((Object)n2, null)));
        Assertions.assertEquals((int)0, (int)IterableUtils.size((Iterable)g.getConnectedNodes((Object)n2, EdgeDirection.OUTGOING)));
        Assertions.assertEquals((int)1, (int)IterableUtils.size((Iterable)g.getConnectedNodes((Object)n2, EdgeDirection.INGOING)));
        Assertions.assertTrue((boolean)g.hasEdge((Object)n1, (Object)n2));
        Assertions.assertFalse((boolean)g.hasEdge((Object)n2, (Object)n1));
        Assertions.assertTrue((boolean)g.hasNode("N1"));
        Assertions.assertTrue((boolean)g.hasNode("N2"));
        Assertions.assertTrue((boolean)g.hasEdge("E12"));
        Assertions.assertFalse((boolean)g.hasEdge("E21"));
        TestGraphHeavyEdge e21 = (TestGraphHeavyEdge)g.createEdge("E21", "N2", "N1");
        Assertions.assertTrue((boolean)g.hasNodes());
        Assertions.assertEquals((int)2, (int)g.getNodesCount());
        Assertions.assertTrue((boolean)g.hasEdges());
        Assertions.assertEquals((int)2, (int)g.getEdgesCount());
        Assertions.assertEquals((Object)n2, (Object)e21.getSource());
        Assertions.assertEquals((Object)n1, (Object)e21.getTarget());
        Assertions.assertEquals((int)1, (int)IterableUtils.size((Iterable)n1.getOutgoings()));
        Assertions.assertEquals((int)1, (int)IterableUtils.size((Iterable)n1.getIngoings()));
        Assertions.assertEquals((int)1, (int)IterableUtils.size((Iterable)n2.getOutgoings()));
        Assertions.assertEquals((int)1, (int)IterableUtils.size((Iterable)n2.getIngoings()));
        Assertions.assertEquals((int)2, (int)g.getEdgesCount((Object)n1, null));
        Assertions.assertEquals((int)1, (int)g.getEdgesCount((Object)n1, EdgeDirection.OUTGOING));
        Assertions.assertEquals((int)1, (int)g.getEdgesCount((Object)n1, EdgeDirection.INGOING));
        Assertions.assertTrue((boolean)g.hasEdges((Object)n1, null));
        Assertions.assertTrue((boolean)g.hasEdges((Object)n1, EdgeDirection.OUTGOING));
        Assertions.assertTrue((boolean)g.hasEdges((Object)n1, EdgeDirection.INGOING));
        Assertions.assertTrue((boolean)g.hasEdge((Object)n1, (Object)n2));
        Assertions.assertTrue((boolean)g.hasEdge((Object)n2, (Object)n1));
        Assertions.assertEquals((Object)n1, (Object)e12.getTip(EdgeTip.SOURCE));
        Assertions.assertEquals((Object)n2, (Object)e12.getTip(EdgeTip.TARGET));
        g.removeEdge("E21");
        Assertions.assertEquals((int)2, (int)g.getNodesCount());
        Assertions.assertEquals((int)1, (int)g.getEdgesCount());
        Assertions.assertEquals((int)1, (int)IterableUtils.size((Iterable)n1.getOutgoings()));
        Assertions.assertEquals((int)0, (int)IterableUtils.size((Iterable)n1.getIngoings()));
        Assertions.assertEquals((int)0, (int)IterableUtils.size((Iterable)n2.getOutgoings()));
        Assertions.assertEquals((int)1, (int)IterableUtils.size((Iterable)n2.getIngoings()));
        g.removeNode("N2");
        Assertions.assertEquals((int)1, (int)g.getNodesCount());
        Assertions.assertEquals((int)0, (int)g.getEdgesCount());
        Assertions.assertEquals((int)0, (int)IterableUtils.size((Iterable)n1.getOutgoings()));
        Assertions.assertEquals((int)0, (int)IterableUtils.size((Iterable)n1.getIngoings()));
        Assertions.assertEquals((int)0, (int)IterableUtils.size((Iterable)n2.getOutgoings()));
        Assertions.assertEquals((int)0, (int)IterableUtils.size((Iterable)n2.getIngoings()));
        g.clear();
        Assertions.assertFalse((boolean)g.hasNodes());
        Assertions.assertFalse((boolean)g.hasEdges());
    }

    @Test
    void testConnectivity() {
        TestHeavyGraph g = new TestHeavyGraph();
        TestGraphHeavyNode n1 = g.createNode("N1");
        TestGraphHeavyNode n2 = g.createNode("N2");
        TestGraphHeavyNode n3 = g.createNode("N3");
        TestGraphHeavyNode n4 = g.createNode("N4");
        TestGraphHeavyNode n5 = g.createNode("N5");
        g.createEdge("E12", "N1", "N2");
        g.createEdge("E23", "N2", "N3");
        g.createEdge("E44", "N4", "N4");
        Assertions.assertTrue((boolean)g.isRoot((Object)n1));
        Assertions.assertFalse((boolean)g.isLeaf((Object)n1));
        Assertions.assertFalse((boolean)g.isRoot((Object)n2));
        Assertions.assertFalse((boolean)g.isLeaf((Object)n2));
        Assertions.assertFalse((boolean)g.isRoot((Object)n3));
        Assertions.assertTrue((boolean)g.isLeaf((Object)n3));
        Assertions.assertFalse((boolean)g.isRoot((Object)n4));
        Assertions.assertFalse((boolean)g.isLeaf((Object)n4));
        Assertions.assertTrue((boolean)g.isRoot((Object)n5));
        Assertions.assertTrue((boolean)g.isLeaf((Object)n5));
        Assertions.assertEquals((Object)NodeConnectivity.OUT, (Object)g.getConnectivity((Object)n1));
        Assertions.assertEquals((Object)NodeConnectivity.IN_OUT, (Object)g.getConnectivity((Object)n2));
        Assertions.assertEquals((Object)NodeConnectivity.IN, (Object)g.getConnectivity((Object)n3));
        Assertions.assertEquals((Object)NodeConnectivity.IN_OUT, (Object)g.getConnectivity((Object)n4));
        Assertions.assertEquals((Object)NodeConnectivity.ISOLATED, (Object)g.getConnectivity((Object)n5));
        Assertions.assertEquals(GraphBasicQueriesTest.set(n1, n5), (Object)g.getRoots());
        Assertions.assertEquals(GraphBasicQueriesTest.set(n3, n5), (Object)g.getLeaves());
        g.clear();
        Assertions.assertFalse((boolean)g.hasNodes());
        Assertions.assertFalse((boolean)g.hasEdges());
    }
}

