/*
 * Decompiled with CFR 0.152.
 */
package cdc.graphs.impl;

import cdc.graphs.EdgeDirection;
import cdc.graphs.impl.BasicSuperLightGraph;
import cdc.util.function.IterableUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SuperLightGraphTest {
    SuperLightGraphTest() {
    }

    @Test
    void test() {
        BasicSuperLightGraph graph = new BasicSuperLightGraph();
        Assertions.assertSame((Object)0, (Object)graph.getEdgesCount());
        Assertions.assertSame((Object)0, (Object)graph.getNodesCount());
        graph.addNode((Object)"N1");
        graph.addNode((Object)"N2");
        Assertions.assertSame((Object)0, (Object)graph.getEdgesCount());
        Assertions.assertSame((Object)2, (Object)graph.getNodesCount());
        graph.addEdge((Object)"N1", (Object)"N2");
        Assertions.assertSame((Object)1, (Object)graph.getEdgesCount());
        Assertions.assertSame((Object)2, (Object)graph.getNodesCount());
        Assertions.assertTrue((boolean)graph.containsEdge((Object)"N1", (Object)"N2"));
        Assertions.assertFalse((boolean)graph.containsEdge((Object)"N2", (Object)"N1"));
        Assertions.assertTrue((boolean)graph.containsNode((Object)"N1"));
        Assertions.assertFalse((boolean)graph.containsNode((Object)"N3"));
        Assertions.assertSame((Object)1, (Object)IterableUtils.size((Iterable)graph.getEdges((Object)"N1")));
        Assertions.assertSame((Object)1, (Object)IterableUtils.size((Iterable)graph.getEdges((Object)"N2")));
        Assertions.assertSame((Object)1, (Object)IterableUtils.size((Iterable)graph.getEdges((Object)"N1", EdgeDirection.OUTGOING)));
        Assertions.assertSame((Object)0, (Object)IterableUtils.size((Iterable)graph.getEdges((Object)"N1", EdgeDirection.INGOING)));
        Assertions.assertSame((Object)0, (Object)IterableUtils.size((Iterable)graph.getEdges((Object)"N2", EdgeDirection.OUTGOING)));
        Assertions.assertSame((Object)1, (Object)IterableUtils.size((Iterable)graph.getEdges((Object)"N2", EdgeDirection.INGOING)));
        Assertions.assertSame((Object)1, (Object)graph.getConnectedNodes((Object)"N1", EdgeDirection.OUTGOING).size());
        Assertions.assertSame((Object)0, (Object)graph.getConnectedNodes((Object)"N1", EdgeDirection.INGOING).size());
        Assertions.assertSame((Object)0, (Object)graph.getConnectedNodes((Object)"N2", EdgeDirection.OUTGOING).size());
        Assertions.assertSame((Object)1, (Object)graph.getConnectedNodes((Object)"N2", EdgeDirection.INGOING).size());
        Assertions.assertTrue((boolean)graph.getConnectedNodes((Object)"N1", EdgeDirection.OUTGOING).contains("N2"));
        Assertions.assertTrue((boolean)graph.getConnectedNodes((Object)"N2", EdgeDirection.INGOING).contains("N1"));
    }
}

