/*
 * Decompiled with CFR 0.152.
 */
package cdc.graphs.impl;

import cdc.graphs.EdgeDirection;
import cdc.graphs.EdgeTip;
import cdc.graphs.GraphAdapter;
import cdc.graphs.impl.BasicGraphEdge;
import cdc.graphs.impl.BasicGraphHeavyNode;
import cdc.util.lang.Checks;
import cdc.util.lang.InvalidStateException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class BasicHeavyGraph<N extends BasicGraphHeavyNode<E>, E extends BasicGraphEdge<N>>
implements GraphAdapter<N, E> {
    private final Set<N> nodes = new HashSet<N>();
    private final Set<E> edges = new HashSet();
    private boolean locked = false;

    private void checkIsUnlocked() {
        if (this.locked) {
            throw new InvalidStateException("Locked");
        }
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void clear() {
        this.checkIsUnlocked();
        while (!this.edges.isEmpty()) {
            this.removeEdge((BasicGraphEdge)this.edges.iterator().next());
        }
        this.nodes.clear();
    }

    protected void addNode(N node) {
        this.checkIsUnlocked();
        Checks.isNotNull(node, (String)"node");
        Checks.isFalse((boolean)this.containsNode(node), (String)"Node already declared: {}", node);
        this.nodes.add(node);
    }

    public void removeNode(N node) {
        this.checkIsUnlocked();
        ArrayList tmp = new ArrayList();
        tmp.addAll(((BasicGraphHeavyNode)node).ingoings);
        for (BasicGraphEdge edge : tmp) {
            this.removeEdge(edge);
        }
        tmp.clear();
        tmp.addAll(((BasicGraphHeavyNode)node).outgoings);
        for (BasicGraphEdge edge : tmp) {
            this.removeEdge(edge);
        }
        boolean removed = this.nodes.remove(node);
        assert (removed);
    }

    protected void addEdge(E edge) {
        this.checkIsUnlocked();
        Checks.isNotNull(edge, (String)"edge");
        Checks.isFalse((boolean)this.containsEdge(edge), (String)"Edge already declared: {}", edge);
        Checks.isTrue((boolean)this.containsNode((N)((BasicGraphHeavyNode)((BasicGraphEdge)edge).getSource())), (String)"edge source does not belong to graph");
        Checks.isTrue((boolean)this.containsNode((N)((BasicGraphHeavyNode)((BasicGraphEdge)edge).getTarget())), (String)"edge target does not belong to graph");
        ((BasicGraphHeavyNode)((BasicGraphEdge)edge).getSource()).outgoings.add(edge);
        ((BasicGraphHeavyNode)((BasicGraphEdge)edge).getTarget()).ingoings.add(edge);
        this.edges.add(edge);
    }

    public void removeEdge(E edge) {
        this.checkIsUnlocked();
        boolean removed = ((BasicGraphHeavyNode)((BasicGraphEdge)edge).getSource()).outgoings.remove(edge);
        assert (removed) : "Failed to remove " + edge + " from source " + ((BasicGraphEdge)edge).getSource();
        removed = ((BasicGraphHeavyNode)((BasicGraphEdge)edge).getTarget()).ingoings.remove(edge);
        assert (removed) : "Failed to remove " + edge + " from target " + ((BasicGraphEdge)edge).getTarget();
        removed = this.edges.remove(edge);
        assert (removed) : "Failed to remove " + edge + " from edges";
    }

    public final Iterable<N> getNodes() {
        return this.nodes;
    }

    public final boolean containsNode(N node) {
        return this.nodes.contains(node);
    }

    public final Iterable<E> getEdges() {
        return this.edges;
    }

    public final boolean containsEdge(E edge) {
        return this.edges.contains(edge);
    }

    public final Iterable<E> getEdges(N node, EdgeDirection direction) {
        if (direction == null) {
            HashSet<BasicGraphEdge> tmp = new HashSet<BasicGraphEdge>();
            for (BasicGraphEdge edge : ((BasicGraphHeavyNode)node).getIngoings()) {
                tmp.add(edge);
            }
            for (BasicGraphEdge edge : ((BasicGraphHeavyNode)node).getOutgoings()) {
                tmp.add(edge);
            }
            return tmp;
        }
        if (direction == EdgeDirection.INGOING) {
            return ((BasicGraphHeavyNode)node).getIngoings();
        }
        return ((BasicGraphHeavyNode)node).getOutgoings();
    }

    public final N getTip(E edge, EdgeTip tip) {
        Checks.isNotNull(edge, (String)"edge");
        Checks.isNotNull((Object)tip, (String)"tip");
        if (tip == EdgeTip.SOURCE) {
            return (N)((BasicGraphHeavyNode)((BasicGraphEdge)edge).getSource());
        }
        return (N)((BasicGraphHeavyNode)((BasicGraphEdge)edge).getTarget());
    }
}

