/*
 * Decompiled with CFR 0.152.
 */
package cdc.graphs.impl;

import cdc.graphs.EdgeDirection;
import cdc.graphs.EdgeTip;
import cdc.graphs.GraphAdapter;
import cdc.graphs.GraphConsistencyError;
import cdc.util.function.IterableUtils;
import cdc.util.lang.Checks;
import java.util.function.Predicate;

public class FilteredSubGraph<N, E>
implements GraphAdapter<N, E> {
    private final GraphAdapter<N, E> delegate;
    private Predicate<N> nodePredicate = x -> true;
    private Predicate<E> edgePredicate = x -> true;
    private final Predicate<E> checkedEdgePredicate;

    public FilteredSubGraph(GraphAdapter<N, E> delegate) {
        Checks.isNotNull(delegate, (String)"delegate");
        this.delegate = delegate;
        this.checkedEdgePredicate = input -> {
            boolean pass = this.edgePredicate.test(input);
            if (pass) {
                boolean targetMismatch;
                boolean sourceMismatch = !this.nodePredicate.test(delegate.getTip(input, EdgeTip.SOURCE));
                boolean bl = targetMismatch = !this.nodePredicate.test(delegate.getTip(input, EdgeTip.TARGET));
                if (sourceMismatch || targetMismatch) {
                    throw new GraphConsistencyError("Edge is accepted, but its source or target is not");
                }
            }
            return pass;
        };
    }

    public FilteredSubGraph(GraphAdapter<N, E> delegate, Predicate<N> nodePredicate, Predicate<E> edgePredicate) {
        this(delegate);
        this.setEdgePredicate(edgePredicate);
        this.setNodePredicate(nodePredicate);
    }

    public final void setNodePredicate(Predicate<N> predicate) {
        Checks.isNotNull(predicate, (String)"predicate");
        this.nodePredicate = predicate;
    }

    public final void setEdgePredicate(Predicate<E> predicate) {
        Checks.isNotNull(predicate, (String)"predicate");
        this.edgePredicate = predicate;
    }

    public final Iterable<? extends N> getNodes() {
        return IterableUtils.filter((Iterable)this.delegate.getNodes(), this.nodePredicate);
    }

    public final boolean containsNode(N node) {
        return this.delegate.containsNode(node) && this.nodePredicate.test(node);
    }

    public final Iterable<? extends E> getEdges() {
        return IterableUtils.filter((Iterable)this.delegate.getEdges(), this.checkedEdgePredicate);
    }

    public final boolean containsEdge(E edge) {
        return this.delegate.containsEdge(edge) && this.edgePredicate.test(edge);
    }

    public final Iterable<? extends E> getEdges(N node, EdgeDirection direction) {
        return IterableUtils.filter((Iterable)this.delegate.getEdges(node, direction), this.checkedEdgePredicate);
    }

    public final N getTip(E edge, EdgeTip tip) {
        return (N)this.delegate.getTip(edge, tip);
    }
}

