/*
 * Decompiled with CFR 0.152.
 */
package cdc.graphs.impl;

import cdc.graphs.EdgeDirection;
import cdc.graphs.EdgeTip;
import cdc.graphs.GraphAdapter;
import cdc.graphs.impl.ExplicitSubGraph;
import cdc.util.function.IterableUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;

public class RestrictionSubGraph<N, E>
extends ExplicitSubGraph<N, E> {
    final Set<N> removedNodes = new HashSet<N>();
    private final Predicate<N> isOwnedNode = value -> !this.removedNodes.contains(value);
    final Set<E> removedEdges = new HashSet();
    private final Predicate<E> isOwnedEdge = value -> !this.removedEdges.contains(value);

    public RestrictionSubGraph(GraphAdapter<N, E> delegate) {
        super(delegate);
    }

    @Override
    public final void clear() {
        this.reset();
        for (Object node : this.delegate.getNodes()) {
            this.removedNodes.add(node);
        }
        for (Object edge : this.delegate.getEdges()) {
            this.removedEdges.add(edge);
        }
    }

    public final void reset() {
        this.removedEdges.clear();
        this.removedNodes.clear();
    }

    @Override
    public final boolean isEmpty() {
        return IterableUtils.isEmpty(this.getNodes());
    }

    @Override
    public final void addNode(N node) {
        this.checkNodeValidity(node);
        if (this.removedNodes.contains(node)) {
            this.removedNodes.remove(node);
        }
    }

    @Override
    public final void removeNode(N node) {
        if (this.delegate.containsNode(node)) {
            this.removedNodes.add(node);
            for (Object edge : this.delegate.getEdges(node, EdgeDirection.INGOING)) {
                this.removeEdge(edge);
            }
            for (Object edge : this.delegate.getEdges(node, EdgeDirection.OUTGOING)) {
                this.removeEdge(edge);
            }
        }
    }

    @Override
    public final void addEdge(E edge) {
        this.checkEdgeValidity(edge);
        if (this.removedEdges.contains(edge)) {
            this.removedEdges.remove(edge);
            this.addNode(this.delegate.getTip(edge, EdgeTip.SOURCE));
            this.addNode(this.delegate.getTip(edge, EdgeTip.TARGET));
        }
    }

    @Override
    public final void removeEdge(E edge) {
        if (this.delegate.containsEdge(edge)) {
            this.removedEdges.add(edge);
        }
    }

    @Override
    public final void removeEdges(N source, N target) {
        for (Object edge : this.delegate.getEdges(source, EdgeDirection.OUTGOING)) {
            Object tgt = this.delegate.getTip(edge, EdgeTip.TARGET);
            if (target != tgt) continue;
            this.removedEdges.add(edge);
        }
    }

    public final Set<N> getRemovedNodes() {
        return this.removedNodes;
    }

    public final Set<E> getRemovedEdges() {
        return this.removedEdges;
    }

    public final Iterable<? extends N> getNodes() {
        return IterableUtils.filter((Iterable)this.delegate.getNodes(), this.isOwnedNode);
    }

    public final boolean containsNode(N node) {
        return !this.removedNodes.contains(node) && this.delegate.containsNode(node);
    }

    public final Iterable<? extends E> getEdges() {
        return IterableUtils.filter((Iterable)this.delegate.getEdges(), this.isOwnedEdge);
    }

    public final boolean containsEdge(E edge) {
        return !this.removedEdges.contains(edge) && this.delegate.containsEdge(edge);
    }

    public final Iterable<? extends E> getEdges(N node, EdgeDirection direction) {
        return IterableUtils.filter((Iterable)this.delegate.getEdges(node, direction), this.isOwnedEdge);
    }

    public final N getTip(E edge, EdgeTip tip) {
        return (N)this.delegate.getTip(edge, tip);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.getNodesCount() + " node(s) " + this.getEdgesCount() + " edge(s)";
    }
}

