/*
 * Decompiled with CFR 0.152.
 */
package cdc.graphs.impl;

import cdc.graphs.GraphAdapter;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.HashMap;

public final class GraphPrinter {
    private static final Comparator<Class<?>> CLASS_COMPARATOR = Comparator.comparing(Class::getCanonicalName);

    private GraphPrinter() {
    }

    private static void display(String title, int total, Iterable<?> items, PrintStream out) {
        HashMap counts = new HashMap();
        for (Object item : items) {
            Class<?> key = item.getClass();
            counts.put(key, counts.getOrDefault(key, 0) + 1);
        }
        out.println(title + total);
        counts.keySet().stream().sorted(CLASS_COMPARATOR).forEach(cls -> out.println("   " + cls.getSimpleName() + ": " + counts.get(cls)));
    }

    public static <N, E> void print(GraphAdapter<N, E> adapter, boolean details, PrintStream out) {
        GraphPrinter.display("Nodes: ", adapter.getNodesCount(), adapter.getNodes(), out);
        GraphPrinter.display("Edges: ", adapter.getEdgesCount(), adapter.getEdges(), out);
        if (details) {
            out.println("Details");
            for (Object node : adapter.getNodes()) {
                out.println("   " + node);
            }
            for (Object edge : adapter.getEdges()) {
                out.println("   " + edge);
            }
        }
    }
}

