/*
 * Decompiled with CFR 0.152.
 */
package cdc.graphs.impl;

import cdc.graphs.EdgeDirection;
import cdc.graphs.EdgeTip;
import cdc.graphs.GraphAdapter;
import cdc.graphs.impl.GraphFilter;
import cdc.util.function.IterableUtils;

public abstract class ImplicitSubGraph<N, E>
extends GraphFilter<N, E> {
    protected ImplicitSubGraph(GraphAdapter<N, E> delegate) {
        super(delegate);
    }

    public Iterable<? extends N> getNodes() {
        return IterableUtils.filter((Iterable)this.delegate.getNodes(), arg_0 -> ((ImplicitSubGraph)this).containsNode(arg_0));
    }

    public Iterable<? extends E> getEdges() {
        return IterableUtils.filter((Iterable)this.delegate.getEdges(), this::containsEdge);
    }

    public boolean containsEdge(E edge) {
        return this.getDelegate().containsEdge(edge) && this.containsNode(this.getDelegate().getTip(edge, EdgeTip.SOURCE)) && this.containsNode(this.getDelegate().getTip(edge, EdgeTip.TARGET));
    }

    public Iterable<? extends E> getEdges(N node, EdgeDirection direction) {
        return IterableUtils.filter((Iterable)this.delegate.getEdges(node, direction), this::containsEdge);
    }

    public N getTip(E edge, EdgeTip tip) {
        return (N)this.delegate.getTip(edge, tip);
    }
}

