package cdc.graphs.impl;

import cdc.graphs.impl.tests.TestEdge;
import cdc.graphs.impl.tests.TestGraph;
import cdc.graphs.impl.tests.TestNode;

public class BijectionGenerator {
    public BijectionGenerator() {
        super();
    }

    public <N extends TestNode, E extends TestEdge<N>> void fill(TestGraph<N, E> graph,
                                                                 int size) {
        for (int index = 0; index < size; index++) {
            final N source = graph.getOrCreateNode("S" + index);
            final N target = graph.getOrCreateNode("T" + index);
            graph.createEdge("E" + index, source, target);
        }
    }
}