/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.tools;

import cdc.issues.answers.IssuesAndAnswers;
import cdc.issues.io.IssuesIoFactoryFeatures;
import cdc.issues.io.IssuesReader;
import cdc.issues.tools.Config;
import cdc.issues.tools.SnapshotsAnalyzerImpl;
import cdc.office.ss.WorkbookWriterFeatures;
import cdc.util.cli.AbstractMainSupport;
import cdc.util.cli.FeatureMask;
import cdc.util.cli.MainResult;
import cdc.util.cli.OptionEnum;
import cdc.util.events.ProgressController;
import cdc.util.time.Chronometer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SnapshotsAnalyzer {
    private static final Logger LOGGER = LogManager.getLogger(SnapshotsAnalyzer.class);
    public static final String DEFAULT_BASENAME = "history";
    private final MainArgs margs;

    private SnapshotsAnalyzer(MainArgs margs) {
        this.margs = margs;
    }

    private void info(String message) {
        if (this.margs.features.isEnabled((Enum)MainArgs.Feature.VERBOSE)) {
            LOGGER.info(message);
        }
    }

    private void info(String message, Object ... params) {
        if (this.margs.features.isEnabled((Enum)MainArgs.Feature.VERBOSE)) {
            LOGGER.info(message, params);
        }
    }

    private void execute() throws IOException {
        Chronometer chrono = new Chronometer();
        this.info("Loading snapshots");
        chrono.start();
        SnapshotsAnalyzerImpl analyzer = new SnapshotsAnalyzerImpl();
        for (File snapshot : this.margs.snapshots) {
            this.info("   Loading {}", snapshot);
            IssuesAndAnswers iaa = IssuesReader.load((File)snapshot, (IssuesReader.Settings)IssuesReader.NO_ANSWERS, (ProgressController)ProgressController.VOID, (IssuesIoFactoryFeatures)IssuesIoFactoryFeatures.UTC_FASTEST);
            analyzer.add(iaa.getIssues());
        }
        chrono.suspend();
        this.info("Loaded {} snapshots ({})", this.margs.snapshots.size(), chrono);
        this.info("Projects: {}", analyzer.getProjects());
        this.info("Snapshots: {}", analyzer.getSnapshots());
        if (this.margs.features.contains((Enum)MainArgs.Feature.SPLIT_PROJECTS)) {
            for (String project : analyzer.getProjects()) {
                File file = new File(this.margs.outputDir, this.margs.basename + "-" + project + ".xlsx");
                this.info("Generating {}", file);
                chrono.start();
                analyzer.generate(file, project, WorkbookWriterFeatures.STANDARD_BEST);
                chrono.suspend();
                this.info("Generated {} ({})", file, chrono);
            }
        } else {
            File file = new File(this.margs.outputDir, this.margs.basename + ".xlsx");
            this.info("Generating {}", file);
            chrono.start();
            analyzer.generate(file, WorkbookWriterFeatures.STANDARD_BEST);
            chrono.suspend();
            this.info("Generated {} ({})", file, chrono);
        }
    }

    public static void execute(MainArgs margs) throws IOException {
        SnapshotsAnalyzer instance = new SnapshotsAnalyzer(margs);
        instance.execute();
    }

    public static MainResult exec(String ... args) {
        MainSupport support = new MainSupport();
        support.main(args);
        return support.getResult();
    }

    public static void main(String ... args) {
        SnapshotsAnalyzer.exec(args);
    }

    public static class MainArgs {
        public final List<File> snapshots = new ArrayList<File>();
        public File outputDir;
        public String basename = "history";
        public final FeatureMask<Feature> features = new FeatureMask();

        public static enum Feature implements OptionEnum
        {
            VERBOSE("verbose", "Print progress messages."),
            SPLIT_PROJECTS("split-projects", "Generates one file per project.");

            private final String name;
            private final String description;

            private Feature(String name, String description) {
                this.name = name;
                this.description = description;
            }

            public final String getName() {
                return this.name;
            }

            public final String getDescription() {
                return this.description;
            }
        }
    }

    private static class MainSupport
    extends AbstractMainSupport<MainArgs, Void> {
        private static final String BASENAME = "basename";
        private static final String SNAPSHOT = "snapshot";

        public MainSupport() {
            super(SnapshotsAnalyzer.class, LOGGER);
        }

        protected String getHelpHeader() {
            return "Load snapshots (lists of issues) and create one or more Excel file(s) containing sheets for each project.\nProjects and snapshots are automatically extracted from issues.\nFor each project, the following sheets are generated:\n- history\n- history data\n- issues";
        }

        protected String getVersion() {
            return Config.VERSION;
        }

        protected void addSpecificOptions(Options options) {
            options.addOption(Option.builder().longOpt(SNAPSHOT).desc("Mandatory name(s) of the snapshot file(s).").hasArgs().required().build());
            options.addOption(Option.builder().longOpt("output-dir").desc("Mandatory name of the output directory.").hasArg().required().build());
            options.addOption(Option.builder().longOpt(BASENAME).desc("Optional base name of output file(s) (default: history).").hasArg().build());
            MainSupport.addNoArgOptions((Options)options, MainArgs.Feature.class);
        }

        protected MainArgs analyze(CommandLine cl) throws ParseException {
            MainArgs margs = new MainArgs();
            for (String value : cl.getOptionValues(SNAPSHOT)) {
                File file = new File(value);
                File f = this.getReferencePath().resolve(file.toPath()).toFile();
                IS_FILE.check(cl, SNAPSHOT, (Object)f);
                margs.snapshots.add(f);
            }
            margs.outputDir = this.getValueAsResolvedFile(cl, "output-dir", IS_NULL_OR_DIRECTORY);
            margs.basename = MainSupport.getValueAsString((CommandLine)cl, (String)BASENAME, (String)SnapshotsAnalyzer.DEFAULT_BASENAME);
            MainSupport.setMask((CommandLine)cl, MainArgs.Feature.class, (arg_0, arg_1) -> margs.features.setEnabled(arg_0, arg_1));
            return margs;
        }

        protected Void execute(MainArgs margs) throws IOException {
            SnapshotsAnalyzer.execute(margs);
            return null;
        }
    }
}

