/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.tools;

import cdc.issues.Issue;
import cdc.issues.Labels;
import cdc.issues.NameValueMap;
import cdc.issues.core.io.WorkbooksIo;
import cdc.issues.locations.Location;
import cdc.issues.rules.RuleId;
import cdc.office.ss.WorkbookWriter;
import cdc.office.ss.WorkbookWriterFactory;
import cdc.office.ss.WorkbookWriterFeatures;
import cdc.office.tables.TableSection;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class SnapshotsAnalyzerImpl {
    private final Map<ProjectSnapshot, List<Issue>> psToIssues = new HashMap<ProjectSnapshot, List<Issue>>();
    private final Map<RuleId, String> titles = new HashMap<RuleId, String>();
    private final Map<String, Issue> idHashToIssue = new HashMap<String, Issue>();
    private final Map<String, Set<String>> idHashToSnapshots = new HashMap<String, Set<String>>();

    public void add(Issue issue) {
        ProjectSnapshot ps = new ProjectSnapshot(issue.getProject(), issue.getSnapshot());
        List list = this.psToIssues.computeIfAbsent(ps, k -> new ArrayList());
        list.add(issue);
        this.idHashToIssue.put(issue.getIdHash(), issue);
        this.idHashToSnapshots.computeIfAbsent(issue.getIdHash(), k -> new HashSet()).add(issue.getSnapshot());
        RuleId rid = issue.getRuleId();
        String title = issue.getTitle();
        this.titles.put(rid, title);
    }

    public void add(Collection<Issue> issues) {
        for (Issue issue : issues) {
            this.add(issue);
        }
    }

    public List<String> getProjects() {
        return this.psToIssues.keySet().stream().map(ps -> ps.project).sorted().distinct().toList();
    }

    public List<String> getSnapshots() {
        return this.psToIssues.keySet().stream().map(ps -> ps.snapshot).sorted().distinct().toList();
    }

    public List<String> getSnapshots(String project) {
        return this.psToIssues.keySet().stream().filter(ps -> Objects.equals(project, ps.project)).map(ps -> ps.snapshot).sorted().distinct().toList();
    }

    public List<Issue> getIssues(String project, String snapshot) {
        ProjectSnapshot ps = new ProjectSnapshot(project, snapshot);
        return this.psToIssues.getOrDefault(ps, Collections.emptyList());
    }

    public List<RuleId> getRuleIds(String project) {
        HashSet set = new HashSet();
        for (String snapshot : this.getSnapshots(project)) {
            List<Issue> issues = this.getIssues(project, snapshot);
            issues.stream().map(Issue::getRuleId).forEach(rid -> set.add(rid));
        }
        return set.stream().sorted().toList();
    }

    public List<String> getIssueIdHashes(String project) {
        HashSet<String> set = new HashSet<String>();
        for (List<Issue> list : this.psToIssues.values()) {
            for (Issue issue : list) {
                if (!Objects.equals(project, issue.getProject())) continue;
                set.add(issue.getIdHash());
            }
        }
        return set.stream().sorted().toList();
    }

    private Set<Issue> getIssues(String project, String snapshot, RuleId ruleId) {
        ProjectSnapshot ps = new ProjectSnapshot(project, snapshot);
        return this.psToIssues.get(ps).stream().filter(i -> Objects.equals(ruleId, i.getRuleId())).collect(Collectors.toSet());
    }

    private static CUR compare(Set<Issue> previous, Set<Issue> current) {
        Set previousIdHashes = previous.stream().map(Issue::getIdHash).collect(Collectors.toSet());
        Set currentIdHashes = current.stream().map(Issue::getIdHash).collect(Collectors.toSet());
        HashSet created = new HashSet(currentIdHashes);
        created.removeAll(previousIdHashes);
        HashSet unchanged = new HashSet(currentIdHashes);
        unchanged.retainAll(previousIdHashes);
        HashSet removed = new HashSet(previousIdHashes);
        removed.removeAll(currentIdHashes);
        return new CUR(created.size(), unchanged.size(), removed.size());
    }

    private void createProjectHistory(WorkbookWriter<?> writer, String project) throws IOException {
        List<String> snapshots = this.getSnapshots(project);
        writer.beginSheet(project + " history");
        writer.beginRow(TableSection.HEADER);
        writer.addCell("Domain");
        writer.addCell("Name");
        writer.addCell("Title");
        for (String snapshot : snapshots) {
            writer.addCell("Fixed (" + snapshot + ")");
            writer.addCell("Same (" + snapshot + ")");
            writer.addCell("New (" + snapshot + ")");
            writer.addCell("Total (" + snapshot + ")");
        }
        int[] totals = new int[snapshots.size() * 4];
        for (RuleId ruleId : this.getRuleIds(project)) {
            writer.beginRow(TableSection.DATA);
            writer.addCell(ruleId.getDomain());
            writer.addCell(ruleId.getName());
            writer.addCell(this.titles.get(ruleId));
            Set<Issue> previousIssues = Collections.emptySet();
            int index = 0;
            for (String currentSnapshot : snapshots) {
                Set<Issue> currentIssues = this.getIssues(project, currentSnapshot, ruleId);
                CUR cur = SnapshotsAnalyzerImpl.compare(previousIssues, currentIssues);
                writer.addCell(cur.removed);
                writer.addCell(cur.unchanged);
                writer.addCell(cur.created);
                int total = cur.unchanged + cur.created;
                writer.addCell(total);
                int n = index + 0;
                totals[n] = totals[n] + cur.removed;
                int n2 = index + 1;
                totals[n2] = totals[n2] + cur.unchanged;
                int n3 = index + 2;
                totals[n3] = totals[n3] + cur.created;
                int n4 = index + 3;
                totals[n4] = totals[n4] + total;
                previousIssues = currentIssues;
                index += 4;
            }
        }
        writer.beginRow(TableSection.DATA);
        writer.addEmptyCells(2);
        writer.addCells(new String[]{"Total"});
        for (Object total : (Object)totals) {
            writer.addCell((int)total);
        }
    }

    private void createProjectHistoryData(WorkbookWriter<?> writer, String project) throws IOException {
        List<String> snapshots = this.getSnapshots(project);
        writer.beginSheet(project + " history data");
        writer.beginRow(TableSection.HEADER);
        writer.addCell("Domain");
        writer.addCell("Name");
        writer.addCell("Title");
        writer.addCell("Snapshot");
        writer.addCell("Fixed");
        writer.addCell("Same");
        writer.addCell("New");
        writer.addCell("Total");
        for (RuleId ruleId : this.getRuleIds(project)) {
            Set<Issue> previousIssues = Collections.emptySet();
            for (String currentSnapshot : snapshots) {
                Set<Issue> currentIssues = this.getIssues(project, currentSnapshot, ruleId);
                CUR cur = SnapshotsAnalyzerImpl.compare(previousIssues, currentIssues);
                writer.beginRow(TableSection.DATA);
                writer.addCell(ruleId.getDomain());
                writer.addCell(ruleId.getName());
                writer.addCell(this.titles.get(ruleId));
                writer.addCell(currentSnapshot);
                writer.addCell(cur.removed);
                writer.addCell(cur.unchanged);
                writer.addCell(cur.created);
                writer.addCell(cur.unchanged + cur.created);
                previousIssues = currentIssues;
            }
        }
    }

    private void createProjectIssues(WorkbookWriter<?> writer, String project) throws IOException {
        List<String> snapshots = this.getSnapshots(project);
        writer.beginSheet(project + " issues");
        writer.beginRow(TableSection.HEADER);
        writer.addCell("Id Hash");
        writer.addCell("Domain");
        writer.addCell("Name");
        writer.addCell("Title");
        writer.addCell("Params");
        writer.addCell("Severity");
        writer.addCell("Description");
        writer.addCell("Locations");
        writer.addCell("Metas");
        writer.addCell("Labels");
        writer.addCells(snapshots);
        for (String idHash : this.getIssueIdHashes(project)) {
            writer.beginRow(TableSection.DATA);
            writer.addCell(idHash);
            Issue issue = this.idHashToIssue.get(idHash);
            writer.addCell(issue.getDomain());
            writer.addCell(issue.getName());
            writer.addCell(issue.getTitle());
            writer.addCell(WorkbooksIo.format((NameValueMap)issue.getParams()));
            writer.addCell((Enum)issue.getSeverity());
            writer.addCell(issue.getDescription());
            writer.addCell(WorkbooksIo.format((Location[])issue.getLocations()));
            writer.addCell(WorkbooksIo.format((NameValueMap)issue.getMetas()));
            writer.addCell(WorkbooksIo.format((Labels)issue.getLabels()));
            Set<String> issueSnapshots = this.idHashToSnapshots.get(idHash);
            for (String snapshot : snapshots) {
                if (issueSnapshots.contains(snapshot)) {
                    writer.addCell(1);
                    continue;
                }
                writer.addCell(0);
            }
        }
    }

    public void generate(File file, WorkbookWriterFeatures features) throws IOException {
        WorkbookWriterFactory factory = new WorkbookWriterFactory();
        factory.setEnabled(WorkbookWriterFactory.Hint.POI_STREAMING, true);
        factory.setEnabled(WorkbookWriterFactory.Hint.ZIP32, true);
        try (WorkbookWriter writer = factory.create(file, features);){
            for (String project : this.getProjects()) {
                this.createProjectHistory(writer, project);
                this.createProjectHistoryData(writer, project);
                this.createProjectIssues(writer, project);
            }
            writer.flush();
        }
    }

    public void generate(File file, String project, WorkbookWriterFeatures features) throws IOException {
        WorkbookWriterFactory factory = new WorkbookWriterFactory();
        factory.setEnabled(WorkbookWriterFactory.Hint.POI_STREAMING, true);
        factory.setEnabled(WorkbookWriterFactory.Hint.ZIP32, true);
        try (WorkbookWriter writer = factory.create(file, features);){
            this.createProjectHistory(writer, project);
            this.createProjectHistoryData(writer, project);
            this.createProjectIssues(writer, project);
            writer.flush();
        }
    }

    private record ProjectSnapshot(String project, String snapshot) {
    }

    private record CUR(int created, int unchanged, int removed) {
    }
}

