/*
 * Decompiled with CFR 0.152.
 */
package cdc.kernel.benches;

import cdc.enums.AbstractMask;
import cdc.enums.MaskSupport;
import cdc.enums.Nullable;
import cdc.util.bench.BenchUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.results.format.ResultFormatType;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.SECONDS)
@State(value=Scope.Benchmark)
@Fork(value=1, jvmArgs={"-Xms1G", "-Xmx8G"})
@Warmup(iterations=5, time=100, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=5, time=100, timeUnit=TimeUnit.MILLISECONDS)
public class MaskBench {
    static final List<XMask> NON_NULLABLE_MASKS = new ArrayList<XMask>();
    static final List<XMask> NULLABLE_MASKS = new ArrayList<XMask>();
    @Param(value={"0", "1", "2", "3", "4", "5", "6", "7"})
    public int xIndex;
    @Param(value={"0", "1", "2", "3", "4", "5", "6", "7"})
    public int yIndex;

    @Benchmark
    public XMask benchNonNullableAnd() {
        return (XMask)NON_NULLABLE_MASKS.get(this.xIndex).and(NON_NULLABLE_MASKS.get(this.yIndex));
    }

    @Benchmark
    public XMask benchNullableAnd() {
        return (XMask)NULLABLE_MASKS.get(this.xIndex).and(NULLABLE_MASKS.get(this.yIndex));
    }

    @Benchmark
    public XMask benchNonNullableOr() {
        return (XMask)NON_NULLABLE_MASKS.get(this.xIndex).or(NON_NULLABLE_MASKS.get(this.yIndex));
    }

    @Benchmark
    public XMask benchNullableOr() {
        return (XMask)NULLABLE_MASKS.get(this.xIndex).or(NULLABLE_MASKS.get(this.yIndex));
    }

    @Benchmark
    public XMask benchNonNullableNot() {
        return (XMask)NON_NULLABLE_MASKS.get(this.xIndex).not();
    }

    @Benchmark
    public XMask benchNullableNot() {
        return (XMask)NULLABLE_MASKS.get(this.xIndex).not();
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(MaskBench.class.getSimpleName()).resultFormat(ResultFormatType.CSV).result(BenchUtils.filename((String)"benchmarks", MaskBench.class, (String)".csv")).forks(0).build();
        new Runner(opt).run();
    }

    static {
        NON_NULLABLE_MASKS.add((XMask)XMask.NON_NULLABLE_SUPPORT.create());
        NON_NULLABLE_MASKS.add((XMask)XMask.NON_NULLABLE_SUPPORT.create((Object)X.A));
        NON_NULLABLE_MASKS.add((XMask)XMask.NON_NULLABLE_SUPPORT.create((Object)X.B));
        NON_NULLABLE_MASKS.add((XMask)XMask.NON_NULLABLE_SUPPORT.create((Object)X.C));
        NON_NULLABLE_MASKS.add((XMask)XMask.NON_NULLABLE_SUPPORT.create((Object[])new X[]{X.A, X.B}));
        NON_NULLABLE_MASKS.add((XMask)XMask.NON_NULLABLE_SUPPORT.create((Object[])new X[]{X.A, X.C}));
        NON_NULLABLE_MASKS.add((XMask)XMask.NON_NULLABLE_SUPPORT.create((Object[])new X[]{X.B, X.C}));
        NON_NULLABLE_MASKS.add((XMask)XMask.NON_NULLABLE_SUPPORT.create((Object[])new X[]{X.A, X.B, X.C}));
        NULLABLE_MASKS.add((XMask)XMask.NULLABLE_SUPPORT.create());
        NULLABLE_MASKS.add((XMask)XMask.NULLABLE_SUPPORT.create((Object)X.A));
        NULLABLE_MASKS.add((XMask)XMask.NULLABLE_SUPPORT.create((Object)X.B));
        NULLABLE_MASKS.add((XMask)XMask.NULLABLE_SUPPORT.create((Object)X.C));
        NULLABLE_MASKS.add((XMask)XMask.NULLABLE_SUPPORT.create((Object[])new X[]{X.A, X.B}));
        NULLABLE_MASKS.add((XMask)XMask.NULLABLE_SUPPORT.create((Object[])new X[]{X.A, X.C}));
        NULLABLE_MASKS.add((XMask)XMask.NULLABLE_SUPPORT.create((Object[])new X[]{X.B, X.C}));
        NULLABLE_MASKS.add((XMask)XMask.NULLABLE_SUPPORT.create((Object[])new X[]{X.A, X.B, X.C}));
    }

    private static class XMask
    extends AbstractMask<XMask, X> {
        static final MaskSupport<XMask, X> NON_NULLABLE_SUPPORT = XMask.support(XMask.class, XMask::new, X.class, (Nullable)Nullable.FALSE);
        static final MaskSupport<XMask, X> NULLABLE_SUPPORT = XMask.support(XMask.class, XMask::new, X.class, (Nullable)Nullable.TRUE);

        private XMask(MaskSupport<XMask, X> support, Set<X> values) {
            super(support, values);
        }
    }

    private static enum X {
        A,
        B,
        C;

    }
}

