/*
 * Decompiled with CFR 0.152.
 */
package cdc.converters;

import cdc.converters.Converter;
import cdc.util.lang.Checks;
import cdc.util.lang.Introspection;

public abstract class AbstractConverter<S, T>
implements Converter<S, T> {
    private final Class<S> sourceClass;
    private final Class<T> targetClass;

    public AbstractConverter(Class<S> sourceClass, Class<T> targetClass) {
        Checks.isNotNull(sourceClass, (String)"sourceClass");
        Checks.isNotNull(targetClass, (String)"targetClass");
        this.sourceClass = sourceClass;
        this.targetClass = targetClass;
    }

    @Override
    public final Class<S> getSourceClass() {
        return this.sourceClass;
    }

    @Override
    public final Class<S> getWrappedSourceClass() {
        return Introspection.wrap(this.getSourceClass());
    }

    @Override
    public final Class<T> getTargetClass() {
        return this.targetClass;
    }

    @Override
    public final Class<T> getWrappedTargetClass() {
        return Introspection.wrap(this.getTargetClass());
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + " " + this.getSourceClass().getSimpleName() + "->" + this.getTargetClass().getSimpleName() + this.getParams() + "]";
    }
}

