/*
 * Decompiled with CFR 0.152.
 */
package cdc.converters;

import cdc.args.Arg;
import cdc.args.Args;
import cdc.args.FormalArg;
import cdc.args.FormalArgs;
import cdc.converters.ConversionException;
import cdc.converters.Converters;
import cdc.util.lang.Checks;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ArgsConversion {
    private static final Logger LOGGER = LogManager.getLogger(ArgsConversion.class);

    private ArgsConversion() {
    }

    public static Args convert(Args args, FormalArgs fargs) {
        LOGGER.debug("convert({}, {})", (Object)args, (Object)fargs);
        Checks.isNotNull((Object)args, (String)"args");
        Checks.isNotNull((Object)fargs, (String)"fargs");
        Args.Builder builder = Args.builder();
        for (Arg arg : args.getArgs()) {
            FormalArg farg = fargs.getArg(arg.getName());
            if (farg == null) {
                throw new ConversionException("No formal argument was found for " + arg + " in " + fargs);
            }
            Object value = Converters.convertRaw(arg.getValue(), farg.getType());
            builder.arg(arg.getName(), value);
        }
        return builder.build();
    }

    public static Args convert(Args args, List<FormalArgs> fargsList) {
        LOGGER.debug("convert({}, {})", (Object)args, fargsList);
        Checks.isNotNull((Object)args, (String)"args");
        Checks.isNotNullOrEmpty(fargsList, (String)"fargs");
        for (FormalArgs f : fargsList) {
            try {
                Args result = ArgsConversion.convert(args, f);
                if (result.isStrictlyCompliantWith(f)) {
                    return result;
                }
                LOGGER.debug("No strict compliance of: {} with: {}", (Object)result, (Object)f);
            }
            catch (ConversionException e) {
                LOGGER.debug("Converting: {} with: {} failed, {}", (Object)args, (Object)f, (Object)e.getMessage());
            }
        }
        throw new ConversionException("Can not convert " + args + " to one of " + fargsList);
    }

    public static Args convertToStringValues(Args args) {
        LOGGER.debug("convertToStrings({})", (Object)args);
        Checks.isNotNull((Object)args, (String)"args");
        Args.Builder builder = Args.builder();
        for (Arg arg : args.getArgs()) {
            String value = Converters.convert(arg.getValue(), String.class);
            builder.arg(arg.getName(), (Object)value);
        }
        return builder.build();
    }
}

