/*
 * Decompiled with CFR 0.152.
 */
package cdc.converters;

import cdc.args.Args;
import cdc.args.Factory;
import cdc.args.FormalArg;
import cdc.args.FormalArgs;
import cdc.args.Necessity;
import cdc.converters.AndThenConverter;
import cdc.converters.ConverterAdapter;
import cdc.converters.OrElseConverter;
import cdc.util.lang.Checks;
import cdc.util.lang.Introspection;
import java.lang.reflect.Array;
import java.util.function.Function;

public interface Converter<S, T>
extends Function<S, T> {
    public static final FormalArg<Class<?>> SOURCE_CLASS = new FormalArg("sourceClass", Introspection.uncheckedCast(Class.class), Necessity.MANDATORY);
    public static final FormalArg<Class<?>> TARGET_CLASS = new FormalArg("targetClass", Introspection.uncheckedCast(Class.class), Necessity.MANDATORY);
    public static final FormalArgs META_FARGS = new FormalArgs(new FormalArg[]{SOURCE_CLASS, TARGET_CLASS});

    public Class<S> getSourceClass();

    default public Class<S> getWrappedSourceClass() {
        return Introspection.wrap(this.getSourceClass());
    }

    public Class<T> getTargetClass();

    default public Class<T> getWrappedTargetClass() {
        return Introspection.wrap(this.getTargetClass());
    }

    public Args getParams();

    default public T applyRaw(Object source) {
        S tmp = this.getSourceClass().cast(source);
        return (T)this.apply(tmp);
    }

    default public boolean isCompliantSourceClass(Class<?> cls) {
        return cls != null && this.getWrappedSourceClass().isAssignableFrom(Introspection.wrap(cls));
    }

    default public boolean isCompliantTargetClass(Class<?> cls) {
        return cls != null && Introspection.wrap(cls).isAssignableFrom(this.getWrappedTargetClass());
    }

    default public boolean areCompliantSourceAndTargetClasses(Class<?> sourceClass, Class<?> targetClass) {
        return this.isCompliantSourceClass(sourceClass) && this.isCompliantTargetClass(targetClass);
    }

    default public boolean isMatchingSourceClass(Class<?> cls) {
        return cls != null && this.getWrappedSourceClass().equals(Introspection.wrap(cls));
    }

    default public boolean isMatchingTargetClass(Class<?> cls) {
        return cls != null && Introspection.wrap(cls).equals(this.getWrappedTargetClass());
    }

    default public boolean areMatchingSourceAndTargetClasses(Class<?> sourceClass, Class<?> targetClass) {
        return this.isMatchingSourceClass(sourceClass) && this.isMatchingTargetClass(targetClass);
    }

    @Override
    default public <R> Converter<R, T> compose(Converter<R, ? extends S> before) {
        Checks.isNotNull(before, (String)"before");
        return new AndThenConverter(before, this);
    }

    @Override
    default public <U> Converter<S, U> andThen(Converter<? super T, U> after) {
        Checks.isNotNull(after, (String)"after");
        return new AndThenConverter(this, after);
    }

    default public Converter<S, T> orElse(Converter<? super S, ? extends T> ... others) {
        return new OrElseConverter<S, T>(this, others);
    }

    default public <R, U> Converter<R, U> cast(Class<R> sourceClass, Class<U> targetClass) {
        return Converter.adapt(sourceClass, targetClass, this);
    }

    default public <R> Converter<R, T> composeRaw(Converter<R, ?> before) {
        Checks.isNotNull(before, (String)"before");
        return this.compose(before.cast(before.getSourceClass(), this.getSourceClass()));
    }

    default public <U> Converter<S, U> andThenRaw(Converter<?, U> after) {
        Checks.isNotNull(after, (String)"after");
        return this.andThen(after.cast(this.getTargetClass(), after.getTargetClass()));
    }

    default public Converter<S, T> orElseRaw(Converter<?, ?> ... others) {
        Converter[] array = (Converter[])Array.newInstance(Converter.class, others.length);
        for (int index = 0; index < others.length; ++index) {
            array[index] = others[index].adapt(this.getSourceClass(), this.getTargetClass());
        }
        return this.orElse(array);
    }

    default public <R, U> Converter<R, U> adapt(Class<R> sourceClass, Class<U> targetClass) {
        return Converter.adapt(sourceClass, targetClass, this);
    }

    public static <S, T> Converter<S, T> adapt(Class<S> sourceClass, Class<T> targetClass, Converter<?, ?> delegate) {
        Checks.isNotNull(sourceClass, (String)"sourceClass");
        Checks.isNotNull(targetClass, (String)"targetClass");
        Checks.isNotNull(delegate, (String)"delegate");
        if (sourceClass.equals(delegate.getSourceClass()) && targetClass.equals(delegate.getTargetClass())) {
            Converter<?, ?> tmp = delegate;
            return tmp;
        }
        return new ConverterAdapter<S, T>(sourceClass, targetClass, delegate);
    }

    public static <C extends Converter<S, T>, S, T> Factory<C> singleton(C instance) {
        return Factory.singleton(instance, (Args)Args.builder().arg(SOURCE_CLASS, instance.getSourceClass()).arg(TARGET_CLASS, instance.getTargetClass()).build());
    }
}

