/*
 * Decompiled with CFR 0.152.
 */
package cdc.converters;

import cdc.args.Args;
import cdc.converters.AbstractConverter;
import cdc.converters.Converter;
import cdc.util.debug.Debug;
import cdc.util.lang.Checks;
import cdc.util.lang.Introspection;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ConverterAdapter<S, T>
extends AbstractConverter<S, T> {
    private static final Logger LOGGER = LogManager.getLogger(ConverterAdapter.class);
    private final Converter<?, ?> delegate;

    public ConverterAdapter(Class<S> sourceClass, Class<T> targetClass, Converter<?, ?> delegate) {
        super(sourceClass, targetClass);
        LOGGER.info("<init>({}, {}, {})", (Object)sourceClass.getCanonicalName(), (Object)targetClass.getCanonicalName(), delegate);
        Debug.printStackTrace((Logger)LOGGER, (Level)Level.DEBUG);
        Checks.isNotNull(delegate, (String)"delegate");
        this.delegate = delegate;
        if (!delegate.isCompliantSourceClass(sourceClass)) {
            throw new IllegalArgumentException(sourceClass.getCanonicalName() + " is not compliant with delegate source class of " + delegate);
        }
        if (Introspection.mostGeneralizedWithWrap(targetClass, delegate.getTargetClass()) == null) {
            throw new IllegalArgumentException(targetClass.getCanonicalName() + " and target class of delegate " + delegate + " are not related");
        }
    }

    @Override
    public T apply(S source) {
        return this.getTargetClass().cast(this.delegate.applyRaw(source));
    }

    @Override
    public Args getParams() {
        return Args.NO_ARGS;
    }

    public Converter<?, ?> getDelegate() {
        return this.delegate;
    }

    @Override
    public String toString() {
        return "[" + this.getClass().getSimpleName() + " " + this.getSourceClass().getSimpleName() + "->" + this.getTargetClass().getSimpleName() + " " + this.getDelegate() + "]";
    }
}

