/*
 * Decompiled with CFR 0.152.
 */
package cdc.converters;

import cdc.args.Factories;
import cdc.converters.AndThenConverter;
import cdc.converters.ConversionException;
import cdc.converters.Converter;
import cdc.converters.ConverterAdapter;
import cdc.converters.SpecialConverterKind;
import cdc.converters.defaults.BigDecimalToString;
import cdc.converters.defaults.BigIntegerToString;
import cdc.converters.defaults.BooleanArrayToString;
import cdc.converters.defaults.BooleanListToString;
import cdc.converters.defaults.BooleanToString;
import cdc.converters.defaults.ByteArrayToString;
import cdc.converters.defaults.ByteListToString;
import cdc.converters.defaults.ByteToString;
import cdc.converters.defaults.CharToString;
import cdc.converters.defaults.ClassToString;
import cdc.converters.defaults.DoubleArrayToString;
import cdc.converters.defaults.DoubleListToString;
import cdc.converters.defaults.DoubleToString;
import cdc.converters.defaults.EnumToString;
import cdc.converters.defaults.FileToString;
import cdc.converters.defaults.FloatArrayToString;
import cdc.converters.defaults.FloatListToString;
import cdc.converters.defaults.FloatToString;
import cdc.converters.defaults.Identity;
import cdc.converters.defaults.IntegerArrayToString;
import cdc.converters.defaults.IntegerListToString;
import cdc.converters.defaults.IntegerToString;
import cdc.converters.defaults.LocalDateTimeToString;
import cdc.converters.defaults.LocalDateToString;
import cdc.converters.defaults.LocalTimeToString;
import cdc.converters.defaults.LocaleToString;
import cdc.converters.defaults.LongArrayToString;
import cdc.converters.defaults.LongListToString;
import cdc.converters.defaults.LongToString;
import cdc.converters.defaults.ObjectToString;
import cdc.converters.defaults.ShortArrayToString;
import cdc.converters.defaults.ShortListToString;
import cdc.converters.defaults.ShortToString;
import cdc.converters.defaults.StringFiller;
import cdc.converters.defaults.StringRandomizer;
import cdc.converters.defaults.StringToBigDecimal;
import cdc.converters.defaults.StringToBigInteger;
import cdc.converters.defaults.StringToBoolean;
import cdc.converters.defaults.StringToBooleanArray;
import cdc.converters.defaults.StringToBooleanList;
import cdc.converters.defaults.StringToByte;
import cdc.converters.defaults.StringToByteArray;
import cdc.converters.defaults.StringToByteList;
import cdc.converters.defaults.StringToChar;
import cdc.converters.defaults.StringToClass;
import cdc.converters.defaults.StringToConverter;
import cdc.converters.defaults.StringToDate;
import cdc.converters.defaults.StringToDouble;
import cdc.converters.defaults.StringToDoubleArray;
import cdc.converters.defaults.StringToDoubleList;
import cdc.converters.defaults.StringToEnum;
import cdc.converters.defaults.StringToFile;
import cdc.converters.defaults.StringToFloat;
import cdc.converters.defaults.StringToFloatArray;
import cdc.converters.defaults.StringToFloatList;
import cdc.converters.defaults.StringToInteger;
import cdc.converters.defaults.StringToIntegerArray;
import cdc.converters.defaults.StringToIntegerList;
import cdc.converters.defaults.StringToLocalDate;
import cdc.converters.defaults.StringToLocalDateTime;
import cdc.converters.defaults.StringToLocalTime;
import cdc.converters.defaults.StringToLocale;
import cdc.converters.defaults.StringToLong;
import cdc.converters.defaults.StringToLongArray;
import cdc.converters.defaults.StringToLongList;
import cdc.converters.defaults.StringToShort;
import cdc.converters.defaults.StringToShortArray;
import cdc.converters.defaults.StringToShortList;
import cdc.converters.defaults.ToLowerCase;
import cdc.converters.defaults.ToUpperCase;
import cdc.util.debug.Printable;
import cdc.util.debug.Printables;
import cdc.util.lang.Checks;
import cdc.util.lang.CollectionUtils;
import cdc.util.lang.FailureReaction;
import cdc.util.lang.Introspection;
import cdc.util.lang.NotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Converters {
    private static final Logger LOGGER = LogManager.getLogger(Converters.class);
    private static final Map<String, Converter<?, ?>> MAP = new HashMap();
    public static final Printable PRINTER = new Printer();
    private static final Map<Key, Bucket> BUCKETS;

    private Converters() {
    }

    public static boolean elaborate() {
        return true;
    }

    private static String noConverterFound(String name) {
        return "No '" + name + "' converter found";
    }

    private static String noMatchingConverterFound(String name, Class<?> sourceClass, Class<?> targetClass) {
        return "No " + (name == null ? "" : "'" + name + "' ") + "converter maching " + (sourceClass == null ? "?" : sourceClass.getSimpleName()) + " " + (targetClass == null ? "?" : targetClass.getSimpleName()) + " found";
    }

    private static String noCompliantConverterFound(String name, Class<?> sourceClass, Class<?> targetClass) {
        return "No " + (name == null ? "" : "'" + name + "' ") + "converter compliant with " + (sourceClass == null ? "?" : sourceClass.getSimpleName()) + " " + (targetClass == null ? "?" : targetClass.getSimpleName()) + " found";
    }

    public static void register(Converter<?, ?> converter, String name, boolean isDefault, FailureReaction reaction) {
        LOGGER.debug("register({}, {}, {})", converter, (Object)name, (Object)isDefault);
        Checks.isNotNull(converter, (String)"converter");
        Checks.isNotNull((Object)name, (String)"name");
        if (MAP.containsKey(name)) {
            FailureReaction.onError((String)("Duplicate name '" + name + "'"), (Logger)LOGGER, (FailureReaction)reaction, IllegalArgumentException::new);
        }
        MAP.put(name, converter);
        Key key = new Key(converter.getSourceClass(), converter.getTargetClass());
        Bucket bucket = BUCKETS.computeIfAbsent(key, k -> new Bucket());
        bucket.add(converter);
        if (isDefault) {
            if (bucket.hasDefaultConverter()) {
                FailureReaction.onError((String)("A default converter is already associated to (" + converter.getSourceClass().getSimpleName() + ", " + converter.getTargetClass().getSimpleName() + ")"), (Logger)LOGGER, (FailureReaction)reaction, IllegalArgumentException::new);
            }
            bucket.setDefaultConverter(converter);
        }
    }

    public static void register(Converter<?, ?> converter, boolean isDefault, FailureReaction reaction) {
        LOGGER.debug("register({}, {})", converter, (Object)isDefault);
        Checks.isNotNull(converter, (String)"converter");
        Converters.register(converter, converter.getClass().getSimpleName(), isDefault, reaction);
    }

    public static void register(Converter<?, ?> converter, boolean isDefault) {
        Converters.register(converter, isDefault, FailureReaction.FAIL);
    }

    public static Set<String> getNames() {
        return MAP.keySet();
    }

    public static boolean hasConverter(String name) {
        return MAP.containsKey(name);
    }

    public static boolean hasMatchingConverters(Class<?> sourceClass, Class<?> targetClass) {
        Key key = new Key(sourceClass, targetClass);
        return BUCKETS.containsKey(key);
    }

    public static boolean hasCompliantConverters(Class<?> sourceClass, Class<?> targetClass) {
        for (Map.Entry<Key, Bucket> entry : BUCKETS.entrySet()) {
            for (Converter<?, ?> converter : entry.getValue().getConverters()) {
                if (!converter.areCompliantSourceAndTargetClasses(sourceClass, targetClass)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasSpecialConverter(Class<?> sourceClass, Class<?> targetClass, SpecialConverterKind kind) {
        Checks.isNotNull((Object)((Object)kind), (String)"kind");
        Key key = new Key(sourceClass, targetClass);
        Bucket bucket = BUCKETS.get(key);
        return bucket != null && bucket.getSpecialConverter(kind) != null;
    }

    public static boolean isSpecialConverter(Converter<?, ?> converter, SpecialConverterKind kind) {
        Checks.isNotNull((Object)((Object)kind), (String)"kind");
        if (converter == null) {
            return false;
        }
        return Converters.getMatchingSpecialConverter(converter.getSourceClass(), converter.getTargetClass(), kind, FailureReaction.DEFAULT) == converter;
    }

    public static boolean isSpecialConverterName(String name, SpecialConverterKind kind) {
        Checks.isNotNull((Object)((Object)kind), (String)"kind");
        return Converters.isSpecialConverter(Converters.getConverter(name, FailureReaction.DEFAULT), kind);
    }

    public static Converter<?, ?> getConverter(String name, FailureReaction reaction) {
        return (Converter)NotFoundException.onResult(MAP.get(name), (String)Converters.noConverterFound(name), (Logger)LOGGER, (FailureReaction)reaction, null);
    }

    public static Converter<?, ?> getConverter(String name) {
        return Converters.getConverter(name, FailureReaction.FAIL);
    }

    public static <S, T> Converter<S, T> getMatchingConverter(String name, Class<S> sourceClass, Class<T> targetClass, FailureReaction reaction) {
        Converter<S, S> tmp = MAP.get(name);
        if (tmp != null) {
            if (tmp.areMatchingSourceAndTargetClasses(sourceClass, targetClass)) {
                return (Converter)Introspection.uncheckedCast(tmp);
            }
            return (Converter)NotFoundException.onError((String)("'" + name + "' converter does not match " + sourceClass.getCanonicalName() + " " + targetClass.getCanonicalName()), (Logger)LOGGER, (FailureReaction)reaction, null);
        }
        return (Converter)NotFoundException.onError((String)Converters.noConverterFound(name), (Logger)LOGGER, (FailureReaction)reaction, null);
    }

    public static <S, T> Converter<S, T> getMatchingConverter(String name, Class<S> sourceClass, Class<T> targetClass) {
        return Converters.getMatchingConverter(name, sourceClass, targetClass, FailureReaction.FAIL);
    }

    public static <S, T> Converter<? super S, ? extends T> getCompliantConverter(String name, Class<S> sourceClass, Class<T> targetClass, FailureReaction reaction) {
        Converter<S, S> tmp = MAP.get(name);
        if (tmp != null) {
            if (tmp.areCompliantSourceAndTargetClasses(sourceClass, targetClass)) {
                return (Converter)Introspection.uncheckedCast(tmp);
            }
            return (Converter)NotFoundException.onError((String)("'" + name + "' converter not compliant with " + sourceClass.getCanonicalName() + " " + targetClass.getCanonicalName()), (Logger)LOGGER, (FailureReaction)reaction, null);
        }
        return (Converter)NotFoundException.onError((String)Converters.noConverterFound(name), (Logger)LOGGER, (FailureReaction)reaction, null);
    }

    public static <S, T> Converter<? super S, ? extends T> getCompliantConverter(String name, Class<S> sourceClass, Class<T> targetClass) {
        return Converters.getCompliantConverter(name, sourceClass, targetClass, FailureReaction.FAIL);
    }

    public static <S> List<Converter<S, ?>> getSourceMatchingConverters(Class<S> sourceClass) {
        ArrayList result = new ArrayList();
        for (Map.Entry<Key, Bucket> entry : BUCKETS.entrySet()) {
            for (Converter<S, S> converter : entry.getValue().getConverters()) {
                if (!converter.isMatchingSourceClass(sourceClass)) continue;
                result.add((Converter)Introspection.uncheckedCast(converter));
            }
        }
        return result;
    }

    public static <T> List<Converter<?, T>> getTargetMatchingConverters(Class<T> targetClass) {
        ArrayList result = new ArrayList();
        for (Map.Entry<Key, Bucket> entry : BUCKETS.entrySet()) {
            for (Converter<T, T> converter : entry.getValue().getConverters()) {
                if (!converter.isMatchingTargetClass(targetClass)) continue;
                result.add((Converter)Introspection.uncheckedCast(converter));
            }
        }
        return result;
    }

    public static <S, T> List<Converter<S, T>> getMatchingConverters(Class<S> sourceClass, Class<T> targetClass) {
        Key key = new Key(sourceClass, targetClass);
        Bucket bucket = BUCKETS.get(key);
        if (bucket == null) {
            return Collections.emptyList();
        }
        return (List)Introspection.uncheckedCast(bucket.getConverters());
    }

    public static <S> Set<Converter<? super S, ?>> getSourceCompliantConverters(Class<S> sourceClass, SpecialConverterKind kind) {
        HashSet result = new HashSet();
        for (Map.Entry<Key, Bucket> entry : BUCKETS.entrySet()) {
            if (kind == null) {
                for (Converter<S, S> converter : entry.getValue().getConverters()) {
                    if (!converter.isCompliantSourceClass(sourceClass)) continue;
                    result.add((Converter)Introspection.uncheckedCast(converter));
                }
                continue;
            }
            Converter<S, S> converter = entry.getValue().getSpecialConverter(kind);
            if (converter == null || !converter.isCompliantSourceClass(sourceClass)) continue;
            result.add((Converter)Introspection.uncheckedCast(converter));
        }
        return result;
    }

    public static <T> Set<Converter<?, ? extends T>> getTargetCompliantConverters(Class<T> targetClass, SpecialConverterKind kind) {
        HashSet result = new HashSet();
        for (Map.Entry<Key, Bucket> entry : BUCKETS.entrySet()) {
            if (kind == null) {
                for (Converter<T, T> converter : entry.getValue().getConverters()) {
                    if (!converter.isCompliantTargetClass(targetClass)) continue;
                    result.add((Converter)Introspection.uncheckedCast(converter));
                }
                continue;
            }
            Converter<T, T> converter = entry.getValue().getSpecialConverter(kind);
            if (converter == null || !converter.isCompliantTargetClass(targetClass)) continue;
            result.add((Converter)Introspection.uncheckedCast(converter));
        }
        return result;
    }

    public static <S, T> Set<Converter<? super S, ? extends T>> getCompliantConverters(Class<S> sourceClass, Class<T> targetClass, SpecialConverterKind kind) {
        HashSet<Converter<S, T>> result = new HashSet<Converter<S, T>>();
        for (Map.Entry<Key, Bucket> entry : BUCKETS.entrySet()) {
            if (kind == null) {
                for (Converter<S, S> converter : entry.getValue().getConverters()) {
                    if (!converter.areCompliantSourceAndTargetClasses(sourceClass, targetClass)) continue;
                    result.add((Converter)Introspection.uncheckedCast(converter));
                }
                continue;
            }
            Converter<S, S> converter = entry.getValue().getSpecialConverter(kind);
            if (converter == null || !converter.areCompliantSourceAndTargetClasses(sourceClass, targetClass)) continue;
            result.add((Converter)Introspection.uncheckedCast(converter));
        }
        return result;
    }

    public static <S, T> Converter<S, T> getMatchingSpecialConverter(Class<S> sourceClass, Class<T> targetClass, SpecialConverterKind kind, FailureReaction reaction) {
        Key key = new Key(sourceClass, targetClass);
        Bucket bucket = BUCKETS.get(key);
        if (bucket == null || bucket.getSpecialConverter(kind) == null) {
            return (Converter)NotFoundException.onError((String)Converters.noMatchingConverterFound(null, sourceClass, targetClass), (Logger)LOGGER, (FailureReaction)reaction, null);
        }
        return (Converter)Introspection.uncheckedCast(bucket.getSpecialConverter(kind));
    }

    public static <S, T> Converter<S, T> getMatchingSpecialConverter(Class<S> sourceClass, Class<T> targetClass, SpecialConverterKind kind) {
        return Converters.getMatchingSpecialConverter(sourceClass, targetClass, kind, FailureReaction.FAIL);
    }

    public static <S, T> Converter<? super S, ? extends T> getCompliantSpecialConverter(Class<S> sourceClass, Class<T> targetClass, SpecialConverterKind kind, FailureReaction reaction) {
        Converter<S, T> matching = Converters.getMatchingSpecialConverter(sourceClass, targetClass, kind, FailureReaction.DEFAULT);
        if (matching != null) {
            return matching;
        }
        Set<Converter<S, T>> converters = Converters.getCompliantConverters(sourceClass, targetClass, kind);
        if (converters.isEmpty()) {
            return (Converter)NotFoundException.onError((String)Converters.noCompliantConverterFound(null, sourceClass, targetClass), (Logger)LOGGER, (FailureReaction)reaction, null);
        }
        if (converters.size() != 1) {
            LOGGER.warn("Several compliant converters from {} to {}", (Object)sourceClass.getCanonicalName(), (Object)targetClass.getCanonicalName());
            for (Converter<S, T> converter : converters) {
                LOGGER.warn("   {}", converter);
            }
        }
        return converters.iterator().next();
    }

    public static <S, T> Converter<? super S, ? extends T> getCompliantSpecialConverter(Class<S> sourceClass, Class<T> targetClass, SpecialConverterKind kind) {
        return Converters.getCompliantSpecialConverter(sourceClass, targetClass, kind, FailureReaction.FAIL);
    }

    public static Object convertRaw(String name, Object source) {
        Converter<?, ?> converter = Converters.getConverter(name);
        if (converter == null) {
            throw new ConversionException(Converters.noConverterFound(name));
        }
        return converter.applyRaw(source);
    }

    public static Object convertRaw(Object source, Class<?> targetClass) {
        Checks.isNotNull(targetClass, (String)"targetClass");
        if (source == null) {
            return null;
        }
        Converter<?, ?> converter = Converters.getCompliantSpecialConverter(source.getClass(), targetClass, SpecialConverterKind.DEFAULT_OR_SINGLE, FailureReaction.DEFAULT);
        if (converter == null) {
            if (targetClass.isAssignableFrom(source.getClass())) {
                return source;
            }
            throw new ConversionException("No default or compliant converter from '" + source.getClass().getSimpleName() + "' to '" + targetClass.getSimpleName() + "' is registered");
        }
        return converter.applyRaw(source);
    }

    public static <T> T convert(Object source, Class<T> targetClass) {
        Checks.isNotNull(targetClass, (String)"targetClass");
        return targetClass.cast(Converters.convertRaw(source, targetClass));
    }

    public static <T> void convert(Collection<?> input, Converter<?, ? extends T> converter, Collection<T> output) {
        Checks.isNotNull(input, (String)"input");
        Checks.isNotNull(converter, (String)"converter");
        Checks.isNotNull(output, (String)"output");
        for (Object o : input) {
            T t = converter.applyRaw(o);
            output.add(t);
        }
    }

    public static String toString(Object object, FailureReaction reaction) {
        if (object == null) {
            return null;
        }
        Converter<?, String> converter = Converters.getCompliantSpecialConverter(object.getClass(), String.class, SpecialConverterKind.DEFAULT_OR_SINGLE, String.class.equals(object.getClass()) ? FailureReaction.DEFAULT : reaction);
        if (converter == null) {
            return object.toString();
        }
        return converter.applyRaw(object);
    }

    public static String toString(Object object) {
        return Converters.toString(object, FailureReaction.FAIL);
    }

    public static List<Converter<?, ?>> flatten(Converter<?, ?> converter) {
        Checks.isNotNull(converter, (String)"converter");
        try {
            ArrayList list = new ArrayList();
            Converters.flatten(converter, list);
            return list;
        }
        catch (RuntimeException e) {
            LOGGER.error("Failed to flatten {}, {}", converter, (Object)e.getMessage());
            throw e;
        }
    }

    private static void flatten(Converter<?, ?> converter, List<Converter<?, ?>> list) {
        if (converter instanceof AndThenConverter) {
            Converters.flatten(((AndThenConverter)converter).getBefore(), list);
            Converters.flatten(((AndThenConverter)converter).getAfter(), list);
        } else if (converter instanceof ConverterAdapter) {
            Converters.flatten(((ConverterAdapter)converter).getDelegate(), list);
        } else {
            list.add(converter);
        }
    }

    static {
        Printables.register(Converters.class, (Printable)PRINTER);
        BUCKETS = new HashMap<Key, Bucket>();
        LOGGER.debug("<clinit>()");
        Factories.register(BooleanArrayToString.FACTORY);
        Factories.register(BooleanListToString.FACTORY);
        Factories.register(BooleanToString.FACTORY);
        Factories.register(BigDecimalToString.FACTORY);
        Factories.register(BigIntegerToString.FACTORY);
        Factories.register(ByteArrayToString.FACTORY);
        Factories.register(ByteListToString.FACTORY);
        Factories.register(ByteToString.FACTORY);
        Factories.register(CharToString.FACTORY);
        Factories.register(ClassToString.FACTORY);
        Factories.register(DoubleArrayToString.FACTORY);
        Factories.register(DoubleListToString.FACTORY);
        Factories.register(DoubleToString.FACTORY);
        Factories.register(EnumToString.FACTORY);
        Factories.register(FileToString.FACTORY);
        Factories.register(FloatArrayToString.FACTORY);
        Factories.register(FloatListToString.FACTORY);
        Factories.register(FloatToString.FACTORY);
        Factories.register(Identity.FACTORY);
        Factories.register(IntegerArrayToString.FACTORY);
        Factories.register(IntegerListToString.FACTORY);
        Factories.register(IntegerToString.FACTORY);
        Factories.register(LocaleToString.FACTORY);
        Factories.register(LocalDateToString.FACTORY);
        Factories.register(LocalDateTimeToString.FACTORY);
        Factories.register(LocalTimeToString.FACTORY);
        Factories.register(LongArrayToString.FACTORY);
        Factories.register(LongListToString.FACTORY);
        Factories.register(LongToString.FACTORY);
        Factories.register(ObjectToString.FACTORY);
        Factories.register(ShortArrayToString.FACTORY);
        Factories.register(ShortListToString.FACTORY);
        Factories.register(ShortToString.FACTORY);
        Factories.register(StringFiller.FACTORY);
        Factories.register(StringRandomizer.FACTORY);
        Factories.register(StringToBoolean.FACTORY);
        Factories.register(StringToBooleanArray.FACTORY);
        Factories.register(StringToBooleanList.FACTORY);
        Factories.register(StringToBigDecimal.FACTORY);
        Factories.register(StringToBigInteger.FACTORY);
        Factories.register(StringToByte.FACTORY);
        Factories.register(StringToByteArray.FACTORY);
        Factories.register(StringToByteList.FACTORY);
        Factories.register(StringToChar.FACTORY);
        Factories.register(StringToClass.FACTORY);
        Factories.register(StringToConverter.FACTORY);
        Factories.register(StringToDate.FACTORY);
        Factories.register(StringToDouble.FACTORY);
        Factories.register(StringToDoubleArray.FACTORY);
        Factories.register(StringToDoubleList.FACTORY);
        Factories.register(StringToEnum.FACTORY);
        Factories.register(StringToFile.FACTORY);
        Factories.register(StringToFloat.FACTORY);
        Factories.register(StringToFloatArray.FACTORY);
        Factories.register(StringToFloatList.FACTORY);
        Factories.register(StringToInteger.FACTORY);
        Factories.register(StringToIntegerArray.FACTORY);
        Factories.register(StringToIntegerList.FACTORY);
        Factories.register(StringToLocale.FACTORY);
        Factories.register(StringToLocalDate.FACTORY);
        Factories.register(StringToLocalDateTime.FACTORY);
        Factories.register(StringToLocalTime.FACTORY);
        Factories.register(StringToLong.FACTORY);
        Factories.register(StringToLongArray.FACTORY);
        Factories.register(StringToLongList.FACTORY);
        Factories.register(StringToShort.FACTORY);
        Factories.register(StringToShortArray.FACTORY);
        Factories.register(StringToShortList.FACTORY);
        Factories.register(ToLowerCase.FACTORY);
        Factories.register(ToUpperCase.FACTORY);
        Converters.register(BooleanToString.INSTANCE, true);
        Converters.register(ByteToString.INSTANCE, true);
        Converters.register(BigDecimalToString.INSTANCE, true);
        Converters.register(BigIntegerToString.INSTANCE, true);
        Converters.register(CharToString.INSTANCE, true);
        Converters.register(ClassToString.INSTANCE, true);
        Converters.register(DoubleToString.INSTANCE, true);
        Converters.register(FileToString.INSTANCE, true);
        Converters.register(FloatToString.INSTANCE, true);
        Converters.register(Identity.INSTANCE, true);
        Converters.register(IntegerToString.INSTANCE, true);
        Converters.register(LocaleToString.INSTANCE, true);
        Converters.register(LongToString.INSTANCE, true);
        Converters.register(ObjectToString.INSTANCE, true);
        Converters.register(ShortToString.INSTANCE, true);
        Converters.register(StringToBoolean.INSTANCE, true);
        Converters.register(StringToBigDecimal.INSTANCE, true);
        Converters.register(StringToBigInteger.INSTANCE, true);
        Converters.register(StringToByte.INSTANCE, true);
        Converters.register(StringToChar.INSTANCE, true);
        Converters.register(StringToClass.INSTANCE, true);
        Converters.register(StringToConverter.INSTANCE, true);
        Converters.register(StringToDouble.INSTANCE, true);
        Converters.register(StringToFile.INSTANCE, true);
        Converters.register(StringToFloat.INSTANCE, true);
        Converters.register(StringToInteger.INSTANCE, true);
        Converters.register(StringToLocale.INSTANCE, true);
        Converters.register(StringToLong.INSTANCE, true);
        Converters.register(StringToShort.INSTANCE, true);
        Converters.register(ToUpperCase.INSTANCE, false);
        Converters.register(ToLowerCase.INSTANCE, false);
    }

    protected static class Printer
    implements Printable {
        protected Printer() {
        }

        public void print(PrintStream out, int level) {
            this.indent(out, level);
            out.println("Named converters (" + Converters.getNames().size() + ")");
            for (String name : CollectionUtils.toSortedList(Converters.getNames())) {
                Converter<?, ?> converter = Converters.getConverter(name);
                this.indent(out, level + 1);
                if (Converters.isSpecialConverter(converter, SpecialConverterKind.DEFAULT)) {
                    out.print("D");
                } else {
                    out.print(" ");
                }
                if (Converters.isSpecialConverter(converter, SpecialConverterKind.DEFAULT_OR_SINGLE)) {
                    out.print("S ");
                } else {
                    out.print("  ");
                }
                out.println(name);
                this.indent(out, level + 2);
                out.println(converter);
            }
        }
    }

    private static class Bucket {
        private final List<Converter<?, ?>> converters = new ArrayList();
        private Converter<?, ?> defaultConverter = null;

        public List<Converter<?, ?>> getConverters() {
            return this.converters;
        }

        public void add(Converter<?, ?> converter) {
            this.converters.add(converter);
        }

        public void setDefaultConverter(Converter<?, ?> converter) {
            this.defaultConverter = converter;
        }

        public boolean hasDefaultConverter() {
            return this.defaultConverter != null;
        }

        public Converter<?, ?> getSpecialConverter(SpecialConverterKind kind) {
            if (this.defaultConverter != null) {
                return this.defaultConverter;
            }
            if (kind == SpecialConverterKind.DEFAULT_OR_SINGLE && this.converters.size() == 1) {
                return this.converters.get(0);
            }
            return null;
        }
    }

    private static class Key {
        private final Class<?> source;
        private final Class<?> target;

        public Key(Class<?> source, Class<?> target) {
            this.source = Introspection.wrap(source);
            this.target = Introspection.wrap(target);
        }

        public int hashCode() {
            return this.source.hashCode() + 31 * this.target.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Key)) {
                return false;
            }
            Key other = (Key)object;
            return this.source.equals(other.source) && this.target.equals(other.target);
        }
    }
}

