/*
 * Decompiled with CFR 0.152.
 */
package cdc.converters;

import cdc.args.Args;
import cdc.converters.ConversionException;
import cdc.converters.Converter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OrElseConverter<S, T>
implements Converter<S, T> {
    private final Converter<S, T> first;
    private final List<Converter<? super S, ? extends T>> all = new ArrayList<Converter<? super S, ? extends T>>();

    @SafeVarargs
    public OrElseConverter(Converter<S, T> first, Converter<? super S, ? extends T> ... others) {
        this.first = first;
        this.all.add(first);
        Collections.addAll(this.all, others);
    }

    @Override
    public T apply(S arg) {
        for (Converter<S, S> converter : this.all) {
            try {
                return (T)converter.apply(arg);
            }
            catch (RuntimeException runtimeException) {
            }
        }
        throw new ConversionException("Can not convert '" + arg + "' using any of available converters");
    }

    @Override
    public Class<S> getSourceClass() {
        return this.first.getSourceClass();
    }

    @Override
    public Class<T> getTargetClass() {
        return this.first.getTargetClass();
    }

    @Override
    public Args getParams() {
        return Args.NO_ARGS;
    }

    public int getSize() {
        return this.all.size();
    }

    public Converter<? super S, ? extends T> getConverter(int index) {
        return this.all.get(index);
    }

    public List<Converter<? super S, ? extends T>> getConverters() {
        return this.all;
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + " " + this.all + "]";
    }
}

