/*
 * Decompiled with CFR 0.152.
 */
package cdc.converters;

import cdc.args.Args;
import cdc.converters.Converter;
import cdc.converters.Converters;
import cdc.util.lang.FailureReaction;
import cdc.util.refs.ResolutionException;
import cdc.util.refs.ResolutionStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class RawRefConverter
implements Converter<Object, Object> {
    private static final Logger LOGGER = LogManager.getLogger(RawRefConverter.class);
    private final String name;
    private ResolutionStatus status = ResolutionStatus.PENDING;
    private Converter<Object, Object> delegate = null;

    public RawRefConverter(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void resolve(FailureReaction reaction) {
        if (this.status == ResolutionStatus.PENDING) {
            Converter<?, ?> tmp = Converters.getConverter(this.name, FailureReaction.FAIL);
            this.delegate = tmp;
            this.status = this.delegate == null ? ResolutionStatus.FAILURE : ResolutionStatus.SUCCESS;
        }
        if (this.status == ResolutionStatus.FAILURE) {
            if (reaction == FailureReaction.FAIL) {
                throw new ResolutionException("Failed to resolve " + this.name);
            }
            if (reaction == FailureReaction.WARN) {
                LOGGER.warn("Failed to resolve {}", (Object)this.name);
            }
        }
    }

    public ResolutionStatus getResolutionStatus() {
        return this.status;
    }

    public Converter<?, ?> getDelegate() {
        return this.delegate;
    }

    @Override
    public Object apply(Object value) {
        this.resolve(FailureReaction.FAIL);
        return this.delegate.applyRaw(value);
    }

    @Override
    public Class<Object> getSourceClass() {
        this.resolve(FailureReaction.FAIL);
        return this.delegate.getSourceClass();
    }

    @Override
    public Class<Object> getTargetClass() {
        this.resolve(FailureReaction.FAIL);
        return this.delegate.getTargetClass();
    }

    @Override
    public Args getParams() {
        return Args.NO_ARGS;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        builder.append(this.getClass().getSimpleName());
        builder.append(" '");
        builder.append(this.getName());
        builder.append("' ");
        builder.append(this.getResolutionStatus());
        if (this.getResolutionStatus() == ResolutionStatus.SUCCESS) {
            builder.append(" ");
            builder.append(this.getDelegate());
        }
        builder.append(']');
        return builder.toString();
    }
}

