/*
 * Decompiled with CFR 0.152.
 */
package cdc.converters.defaults;

import cdc.args.AbstractFactory;
import cdc.args.Args;
import cdc.args.Factory;
import cdc.args.FormalArg;
import cdc.args.FormalArgs;
import cdc.converters.AbstractConverter;
import cdc.converters.defaults.NumberConversionSupport;
import java.text.NumberFormat;
import java.util.Locale;

public abstract class AbstractNumberToString<S extends Number>
extends AbstractConverter<S, String> {
    public static final FormalArg<String> PATTERN = NumberConversionSupport.PATTERN;
    public static final FormalArg<Locale> LOCALE = NumberConversionSupport.LOCALE;
    public static final FormalArgs FPARAMS = new FormalArgs(new FormalArg[]{PATTERN, LOCALE});
    private final String pattern;
    private final Locale locale;
    private final String defaultFormat;

    protected static <C extends AbstractNumberToString<S>, S extends Number> Factory<C> factory(Class<C> converterClass, Class<S> numberClass, final Creator<C> creator) {
        return new AbstractFactory<C>(converterClass, Args.builder().arg(SOURCE_CLASS, numberClass).arg(TARGET_CLASS, String.class).build(), new FormalArgs[]{FPARAMS}){

            protected C create(Args args, FormalArgs fargs) {
                String pattern = (String)args.getValue(PATTERN);
                Locale locale = (Locale)args.getValue(LOCALE);
                return (AbstractNumberToString)creator.create(pattern, locale);
            }
        };
    }

    protected AbstractNumberToString(Class<S> sourceClass, String pattern, Locale locale, String defaultFormat) {
        super(sourceClass, String.class);
        this.pattern = pattern;
        this.locale = locale;
        this.defaultFormat = defaultFormat;
    }

    @Override
    public final String apply(S source) {
        if (source == null) {
            return null;
        }
        if (this.pattern == null) {
            if (this.locale == null) {
                return source.toString();
            }
            return String.format(this.locale, this.defaultFormat, source);
        }
        NumberFormat format = NumberConversionSupport.getFormat(this.pattern, this.locale);
        return format.format(source);
    }

    @Override
    public Args getParams() {
        return Args.builder((FormalArgs)FPARAMS).arg(PATTERN, (Object)this.getPattern()).arg(LOCALE, (Object)this.getLocale()).build();
    }

    public final String getPattern() {
        return this.pattern;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public final String getDefaultFormat() {
        return this.defaultFormat;
    }

    @FunctionalInterface
    protected static interface Creator<C> {
        public C create(String var1, Locale var2);
    }
}

