/*
 * Decompiled with CFR 0.152.
 */
package cdc.converters.defaults;

import cdc.args.AbstractFactory;
import cdc.args.Args;
import cdc.args.Factory;
import cdc.args.FormalArg;
import cdc.args.FormalArgs;
import cdc.converters.AbstractConverter;
import cdc.converters.ConversionException;
import cdc.converters.defaults.NumberConversionSupport;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.function.Function;

public class AbstractStringToNumber<T extends Number>
extends AbstractConverter<String, T> {
    public static final FormalArg<String> PATTERN = NumberConversionSupport.PATTERN;
    public static final FormalArg<Locale> LOCALE = NumberConversionSupport.LOCALE;
    public static final FormalArgs FPARAMS = new FormalArgs(new FormalArg[]{PATTERN, LOCALE});
    private final String pattern;
    private final Locale locale;
    private final NumberFormat format;
    private final Function<Number, T> extractor;

    protected static <C extends AbstractStringToNumber<T>, T extends Number> Factory<C> factory(Class<C> converterClass, Class<T> numberClass, final Creator<C> creator, final String defaultPattern) {
        return new AbstractFactory<C>(converterClass, Args.builder().arg(SOURCE_CLASS, String.class).arg(TARGET_CLASS, numberClass).build(), new FormalArgs[]{FPARAMS}){

            protected C create(Args args, FormalArgs fargs) {
                String pattern = (String)args.getValue(PATTERN, (Object)defaultPattern);
                Locale locale = (Locale)args.getValue(LOCALE);
                return (AbstractStringToNumber)creator.create(pattern, locale);
            }
        };
    }

    protected AbstractStringToNumber(Class<T> targetClass, String pattern, Locale locale, Function<Number, T> extractor) {
        super(String.class, targetClass);
        this.pattern = pattern;
        this.locale = locale;
        this.extractor = extractor;
        this.format = NumberConversionSupport.getFormat(pattern, locale);
    }

    @Override
    public final T apply(String source) {
        if (source == null || source.isEmpty()) {
            return null;
        }
        try {
            Number number = this.format.parse(source);
            return (T)((Number)this.extractor.apply(number));
        }
        catch (ParseException e) {
            throw new ConversionException("Parse error: Can not convert '" + source + "' to " + this.getTargetClass().getSimpleName(), e);
        }
    }

    @Override
    public Args getParams() {
        return Args.builder((FormalArgs)FPARAMS).arg(PATTERN, (Object)this.getPattern()).arg(LOCALE, (Object)this.getLocale()).build();
    }

    public final String getPattern() {
        return this.pattern;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    @FunctionalInterface
    protected static interface Creator<C> {
        public C create(String var1, Locale var2);
    }
}

