/*
 * Decompiled with CFR 0.152.
 */
package cdc.converters.defaults;

import cdc.args.FormalArg;
import cdc.args.Necessity;
import cdc.converters.defaults.AbstractSequenceConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public abstract class AbstractStringToSequence<T>
extends AbstractSequenceConverter<String, T> {
    private final boolean trim;
    public static final FormalArg<Boolean> TRIM = new FormalArg("trim", Boolean.class, Necessity.OPTIONAL);

    public AbstractStringToSequence(Class<T> targetClass, String prefix, String separator, String suffix, boolean trim) {
        super(String.class, targetClass, prefix, separator, suffix);
        this.trim = trim;
    }

    public final boolean getTrim() {
        return this.trim;
    }

    protected <V> List<V> toList(String s, Function<String, ? extends V> converter) {
        int start = this.getPrefix().length();
        int end = this.getSuffix().length();
        String content = s.substring(start, s.length() - end);
        ArrayList<V> list = new ArrayList<V>();
        int from = 0;
        while (from < content.length()) {
            String item;
            int to = content.indexOf(this.getSeparator(), from);
            if (to < 0) {
                item = content.substring(from);
                from = content.length();
            } else {
                item = content.substring(from, to);
                from = to + this.getSeparator().length();
            }
            if (this.getTrim()) {
                list.add(converter.apply(item.trim()));
                continue;
            }
            list.add(converter.apply(item));
        }
        return list;
    }
}

