/*
 * Decompiled with CFR 0.152.
 */
package cdc.converters.defaults;

import cdc.args.AbstractFactory;
import cdc.args.Args;
import cdc.args.Factory;
import cdc.args.FormalArg;
import cdc.args.FormalArgs;
import cdc.converters.AbstractConverter;
import cdc.converters.ConversionException;
import cdc.converters.defaults.DateConversionSupport;
import cdc.util.lang.Checks;
import java.time.DateTimeException;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;

public abstract class AbstractStringToTemporal<T extends TemporalAccessor>
extends AbstractConverter<String, T> {
    private final DateTimeFormatter formatter;
    private final String pattern;
    private final Locale locale;
    public static final FormalArg<DateTimeFormatter> FORMATTER = DateConversionSupport.FORMATTER;
    public static final FormalArgs FPARAMS_FORMATTER = DateConversionSupport.FPARAMS_FORMATTER;
    public static final FormalArg<String> PATTERN = DateConversionSupport.PATTERN;
    public static final FormalArg<Locale> LOCALE = DateConversionSupport.LOCALE;
    public static final FormalArgs FPARAMS_PATTERN_LOCALE = DateConversionSupport.FPARAMS_PATTERN_LOCALE;

    protected static <C extends AbstractStringToTemporal<T>, T extends TemporalAccessor> Factory<C> factory(Class<C> converterClass, Class<T> temporalClass, final C autoConverter, final Function<DateTimeFormatter, C> builderFormatter, final BiFunction<String, Locale, C> builderPatternLocale) {
        return new AbstractFactory<C>(converterClass, Args.builder().arg(SOURCE_CLASS, String.class).arg(TARGET_CLASS, temporalClass).build(), new FormalArgs[]{FormalArgs.NO_FARGS, FPARAMS_PATTERN_LOCALE, FPARAMS_FORMATTER}){

            protected C create(Args args, FormalArgs fargs) {
                if (fargs == FPARAMS_FORMATTER) {
                    DateTimeFormatter vformatter = (DateTimeFormatter)args.getValue(FORMATTER);
                    return (AbstractStringToTemporal)builderFormatter.apply(vformatter);
                }
                if (fargs == FPARAMS_PATTERN_LOCALE) {
                    String vpattern = (String)args.getValue(PATTERN);
                    Locale vlocale = (Locale)args.getValue(LOCALE, null);
                    return (AbstractStringToTemporal)builderPatternLocale.apply(vpattern, vlocale);
                }
                return autoConverter;
            }
        };
    }

    protected AbstractStringToTemporal(Class<T> targetClass) {
        super(String.class, targetClass);
        this.formatter = null;
        this.pattern = null;
        this.locale = null;
    }

    protected AbstractStringToTemporal(Class<T> targetClass, DateTimeFormatter formatter, String pattern, Locale locale) {
        super(String.class, targetClass);
        Checks.isNotNull((Object)formatter, (String)"formatter");
        this.formatter = formatter;
        this.pattern = pattern;
        this.locale = locale;
    }

    public final DateTimeFormatter getFormatter() {
        return this.formatter;
    }

    public final String getPattern() {
        return this.pattern;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    @Override
    public final Args getParams() {
        if (this.formatter == null) {
            return Args.NO_ARGS;
        }
        if (this.pattern == null) {
            return Args.builder((FormalArgs)FPARAMS_FORMATTER).arg(FORMATTER, (Object)this.getFormatter()).build();
        }
        return Args.builder((FormalArgs)FPARAMS_PATTERN_LOCALE).arg(PATTERN, (Object)this.getPattern()).arg(LOCALE, (Object)this.getLocale()).build();
    }

    protected T apply(String source, BiFunction<String, DateTimeFormatter, T> parser, Default[] defaults) {
        if (source == null || source.isEmpty()) {
            return null;
        }
        if (this.formatter == null) {
            for (Default def : defaults) {
                try {
                    return (T)((TemporalAccessor)parser.apply(source, def.formatter));
                }
                catch (DateTimeException dateTimeException) {
                }
            }
            throw new ConversionException("Failed to parse '" + source + "' using default formats");
        }
        return (T)((TemporalAccessor)parser.apply(source, this.getFormatter()));
    }

    protected static class Default {
        final String pattern;
        final DateTimeFormatter formatter;

        public Default(String pattern) {
            this.pattern = pattern;
            this.formatter = DateTimeFormatter.ofPattern(pattern);
        }
    }
}

