/*
 * Decompiled with CFR 0.152.
 */
package cdc.converters.defaults;

import cdc.args.AbstractFactory;
import cdc.args.Args;
import cdc.args.Factory;
import cdc.args.FormalArg;
import cdc.args.FormalArgs;
import cdc.converters.AbstractConverter;
import cdc.converters.defaults.DateConversionSupport;
import cdc.util.lang.Checks;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;

public abstract class AbstractTemporalToString<S extends TemporalAccessor>
extends AbstractConverter<S, String> {
    private final DateTimeFormatter formatter;
    private final String pattern;
    private final Locale locale;
    public static final FormalArg<DateTimeFormatter> FORMATTER = DateConversionSupport.FORMATTER;
    public static final FormalArgs FPARAMS1 = DateConversionSupport.FPARAMS_FORMATTER;
    public static final FormalArg<String> PATTERN = DateConversionSupport.PATTERN;
    public static final FormalArg<Locale> LOCALE = DateConversionSupport.LOCALE;
    public static final FormalArgs FPARAMS2 = DateConversionSupport.FPARAMS_PATTERN_LOCALE;

    protected static <X extends AbstractTemporalToString<S>, S extends TemporalAccessor> Factory<X> factory(Class<X> converterClass, Class<S> sourceClass, final Function<DateTimeFormatter, X> builder1, final BiFunction<String, Locale, X> builder2) {
        return new AbstractFactory<X>(converterClass, Args.builder().arg(SOURCE_CLASS, sourceClass).arg(TARGET_CLASS, String.class).build(), new FormalArgs[]{FPARAMS2, FPARAMS1}){

            protected X create(Args args, FormalArgs fargs) {
                if (fargs == FPARAMS1) {
                    DateTimeFormatter vformatter = (DateTimeFormatter)args.getValue(FORMATTER);
                    return (AbstractTemporalToString)builder1.apply(vformatter);
                }
                String vpattern = (String)args.getValue(PATTERN);
                Locale vlocale = (Locale)args.getValue(LOCALE, null);
                return (AbstractTemporalToString)builder2.apply(vpattern, vlocale);
            }
        };
    }

    protected AbstractTemporalToString(Class<S> sourceClass, DateTimeFormatter formatter, String pattern, Locale locale) {
        super(sourceClass, String.class);
        Checks.isNotNull((Object)formatter, (String)"formatter");
        this.formatter = formatter;
        this.pattern = pattern;
        this.locale = locale;
    }

    public final DateTimeFormatter getFormatter() {
        return this.formatter;
    }

    public final String getPattern() {
        return this.pattern;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    @Override
    public final String apply(S source) {
        return source == null ? null : this.formatter.format((TemporalAccessor)source);
    }

    @Override
    public final Args getParams() {
        if (this.pattern == null) {
            return Args.builder((FormalArgs)FPARAMS1).arg(FORMATTER, (Object)this.getFormatter()).build();
        }
        return Args.builder((FormalArgs)FPARAMS2).arg(PATTERN, (Object)this.getPattern()).arg(LOCALE, (Object)this.getLocale()).build();
    }
}

