/*
 * Decompiled with CFR 0.152.
 */
package cdc.converters.defaults;

import cdc.args.AbstractFactory;
import cdc.args.Args;
import cdc.args.Factory;
import cdc.args.FormalArg;
import cdc.args.FormalArgs;
import cdc.args.Necessity;
import cdc.converters.Converter;
import cdc.converters.defaults.AbstractSequenceConverter;
import cdc.converters.defaults.AbstractSequenceToString;
import cdc.util.lang.Checks;
import cdc.util.lang.Introspection;

public class ArrayToString<S>
extends AbstractSequenceToString<S[]> {
    private final Converter<? super S, String> converter;
    private final Class<S> elementClass;
    public static final FormalArg<Converter<?, String>> CONVERTER = new FormalArg("converter", Introspection.uncheckedCast(Converter.class), Necessity.MANDATORY);
    public static final FormalArgs FPARAMS = new FormalArgs(new FormalArg[]{PREFIX, SEPARATOR, SUFFIX, CONVERTER});
    public static final Factory<ArrayToString<?>> FACTORY = new AbstractFactory<ArrayToString<?>>(Introspection.uncheckedCast(ArrayToString.class), Args.builder().arg(SOURCE_CLASS, Object[].class).arg(TARGET_CLASS, String.class).build(), new FormalArgs[]{FPARAMS}){

        protected ArrayToString<?> create(Args args, FormalArgs fargs) {
            String prefix = (String)args.getValue(AbstractSequenceConverter.PREFIX, null);
            String separator = (String)args.getValue(AbstractSequenceConverter.SEPARATOR, null);
            String suffix = (String)args.getValue(AbstractSequenceConverter.SUFFIX, null);
            Converter converter = (Converter)Introspection.uncheckedCast((Object)args.getValue(CONVERTER));
            Class elementClass = converter.getWrappedSourceClass();
            return ArrayToString.create(elementClass, prefix, separator, suffix, converter);
        }
    };

    protected static <C extends ArrayToString<S>, S> Factory<C> factory(Class<C> converterClass, final Class<S> elementClass, final Creator<C, S> creator) {
        return new AbstractFactory<C>(converterClass, Args.builder().arg(SOURCE_CLASS, (Object)Introspection.getArrayClass(elementClass)).arg(TARGET_CLASS, String.class).build(), new FormalArgs[]{FPARAMS}){

            protected C create(Args args, FormalArgs fargs) {
                String prefix = (String)args.getValue(AbstractSequenceConverter.PREFIX, null);
                String separator = (String)args.getValue(AbstractSequenceConverter.SEPARATOR, null);
                String suffix = (String)args.getValue(AbstractSequenceConverter.SUFFIX, null);
                Converter converter = (Converter)Introspection.uncheckedCast((Object)args.getValue(CONVERTER));
                Checks.isTrue((boolean)converter.isCompliantSourceClass(elementClass), (String)"Non compliant converter");
                return (ArrayToString)creator.create(prefix, separator, suffix, converter);
            }
        };
    }

    public ArrayToString(Class<S> elementClass, String prefix, String separator, String suffix, Converter<? super S, String> converter) {
        super(Introspection.getArrayClass(elementClass), prefix, separator, suffix);
        Checks.isNotNull(converter, (String)"converter");
        this.converter = converter;
        this.elementClass = elementClass;
    }

    public static <S> ArrayToString<S> create(Class<S> elementClass, String prefix, String separator, String suffix, Converter<? super S, String> converter) {
        return new ArrayToString<S>(elementClass, prefix, separator, suffix, converter);
    }

    public final Converter<? super S, String> getConverter() {
        return this.converter;
    }

    public final Class<S> getElementClass() {
        return this.elementClass;
    }

    @Override
    public String apply(S[] array) {
        return this.toString(this.converter, array);
    }

    @Override
    public Args getParams() {
        return Args.builder().arg(PREFIX, (Object)this.getPrefix()).arg(SEPARATOR, (Object)this.getSeparator()).arg(SUFFIX, (Object)this.getSuffix()).arg(CONVERTER, this.getConverter()).build();
    }

    @FunctionalInterface
    protected static interface Creator<C, S> {
        public C create(String var1, String var2, String var3, Converter<? super S, String> var4);
    }
}

