/*
 * Decompiled with CFR 0.152.
 */
package cdc.converters.defaults;

import cdc.args.AbstractFactory;
import cdc.args.Args;
import cdc.args.Factory;
import cdc.args.FormalArg;
import cdc.args.FormalArgs;
import cdc.converters.AbstractConverter;
import cdc.converters.defaults.DateConversionSupport;
import cdc.util.lang.Checks;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public final class DateToString
extends AbstractConverter<Date, String> {
    private final DateFormat format;
    private final String pattern;
    private final Locale locale;
    public static final DateToString DASH_YYYY_MM_DD = DateToString.create("yyyy-MM-dd", null);
    public static final DateToString SLASH_YYYY_MM_DD = DateToString.create("yyyy/MM/dd", null);
    public static final DateToString DASH_DD_MM_YYYY = DateToString.create("dd-MM-yyyy", null);
    public static final DateToString SLASH_DD_MM_YYYY = DateToString.create("dd/MM/yyyy", null);
    public static final DateToString HH_MM_SS = DateToString.create("HH:mm:ss", null);
    public static final DateToString DASH_YYYY_MM_DD_HH_MM_SS = DateToString.create("yyyy-MM-dd HH:mm:ss", null);
    public static final DateToString DASH_DD_MM_YYYY_HH_MM_SS = DateToString.create("dd-MM-yyyy HH:mm:ss", null);
    public static final DateToString SLASH_YYYY_MM_DD_HH_MM_SS = DateToString.create("yyyy/MM/dd HH:mm:ss", null);
    public static final DateToString SLASH_DD_MM_YYYY_HH_MM_SS = DateToString.create("dd/MM/yyyy HH:mm:ss", null);
    public static final FormalArg<DateFormat> FORMAT = DateConversionSupport.FORMAT;
    public static final FormalArgs FPARAMS_FORMAT = DateConversionSupport.FPARAMS_FORMAT;
    public static final FormalArg<String> PATTERN = DateConversionSupport.PATTERN;
    public static final FormalArg<Locale> LOCALE = DateConversionSupport.LOCALE;
    public static final FormalArgs FPARAMS_PATTERN_LOCALE = DateConversionSupport.FPARAMS_PATTERN_LOCALE;
    public static final Factory<DateToString> FACTORY = new AbstractFactory<DateToString>(DateToString.class, Args.builder().arg(SOURCE_CLASS, Date.class).arg(TARGET_CLASS, String.class).build(), new FormalArgs[]{FPARAMS_PATTERN_LOCALE, FPARAMS_FORMAT}){

        protected DateToString create(Args args, FormalArgs fargs) {
            if (fargs == FPARAMS_FORMAT) {
                DateFormat vformat = (DateFormat)args.getValue(FORMAT);
                return DateToString.create(vformat);
            }
            String vpattern = (String)args.getValue(PATTERN);
            Locale vlocale = (Locale)args.getValue(LOCALE, null);
            return DateToString.create(vpattern, vlocale);
        }
    };

    private DateToString(DateFormat format, String pattern, Locale locale) {
        super(Date.class, String.class);
        Checks.isNotNull((Object)format, (String)"format");
        this.format = format;
        this.pattern = pattern;
        this.locale = locale;
    }

    public static DateToString create(DateFormat format) {
        return new DateToString(format, null, null);
    }

    public static DateToString create(String pattern, Locale locale) {
        SimpleDateFormat format = locale == null ? new SimpleDateFormat(pattern) : new SimpleDateFormat(pattern, locale);
        format.setLenient(false);
        return new DateToString(format, pattern, locale);
    }

    public DateFormat getFormat() {
        return this.format;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public String apply(Date source) {
        return source == null ? null : this.format.format(source);
    }

    @Override
    public Args getParams() {
        if (this.pattern == null) {
            return Args.builder((FormalArgs)FPARAMS_FORMAT).arg(FORMAT, (Object)this.getFormat()).build();
        }
        return Args.builder((FormalArgs)FPARAMS_PATTERN_LOCALE).arg(PATTERN, (Object)this.getPattern()).arg(LOCALE, (Object)this.getLocale()).build();
    }
}

