/*
 * Decompiled with CFR 0.152.
 */
package cdc.converters.defaults;

import cdc.args.Factory;
import cdc.converters.defaults.AbstractTemporalToString;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public final class LocalDateToString
extends AbstractTemporalToString<LocalDate> {
    public static final LocalDateToString BASIC_ISO_DATE = LocalDateToString.create(DateTimeFormatter.BASIC_ISO_DATE);
    public static final LocalDateToString ISO_DATE = LocalDateToString.create(DateTimeFormatter.ISO_DATE);
    public static final LocalDateToString ISO_LOCAL_DATE = LocalDateToString.create(DateTimeFormatter.ISO_LOCAL_DATE);
    public static final LocalDateToString DASH_YYYY_MM_DD = LocalDateToString.create("yyyy-MM-dd", null);
    public static final LocalDateToString SLASH_YYYY_MM_DD = LocalDateToString.create("yyyy/MM/dd", null);
    public static final LocalDateToString DASH_DD_MM_YYYY = LocalDateToString.create("dd-MM-yyyy", null);
    public static final LocalDateToString SLASH_DD_MM_YYYY = LocalDateToString.create("dd/MM/yyyy", null);
    public static final Factory<LocalDateToString> FACTORY = LocalDateToString.factory(LocalDateToString.class, LocalDate.class, LocalDateToString::create, LocalDateToString::create);

    private LocalDateToString(DateTimeFormatter formatter, String pattern, Locale locale) {
        super(LocalDate.class, formatter, pattern, locale);
    }

    public static LocalDateToString create(DateTimeFormatter formatter) {
        return new LocalDateToString(formatter, null, null);
    }

    public static LocalDateToString create(String pattern, Locale locale) {
        DateTimeFormatter formatter = locale == null ? DateTimeFormatter.ofPattern(pattern) : DateTimeFormatter.ofPattern(pattern, locale);
        return new LocalDateToString(formatter, pattern, locale);
    }
}

