/*
 * Decompiled with CFR 0.152.
 */
package cdc.converters.defaults;

import cdc.args.Factory;
import cdc.converters.defaults.AbstractTemporalToString;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public final class LocalTimeToString
extends AbstractTemporalToString<LocalTime> {
    public static final LocalTimeToString ISO_LOCAL_TIME = LocalTimeToString.create(DateTimeFormatter.ISO_LOCAL_TIME);
    public static final LocalTimeToString ISO_TIME = LocalTimeToString.create(DateTimeFormatter.ISO_TIME);
    public static final LocalTimeToString HH_MM_SS = LocalTimeToString.create("HH:mm:ss", null);
    public static final Factory<LocalTimeToString> FACTORY = LocalTimeToString.factory(LocalTimeToString.class, LocalTime.class, LocalTimeToString::create, LocalTimeToString::create);

    private LocalTimeToString(DateTimeFormatter formatter, String pattern, Locale locale) {
        super(LocalTime.class, formatter, pattern, locale);
    }

    public static LocalTimeToString create(DateTimeFormatter formatter) {
        return new LocalTimeToString(formatter, null, null);
    }

    public static LocalTimeToString create(String pattern, Locale locale) {
        DateTimeFormatter formatter = locale == null ? DateTimeFormatter.ofPattern(pattern) : DateTimeFormatter.ofPattern(pattern, locale);
        return new LocalTimeToString(formatter, pattern, locale);
    }
}

