/*
 * Decompiled with CFR 0.152.
 */
package cdc.converters.defaults;

import cdc.args.AbstractFactory;
import cdc.args.Args;
import cdc.args.Factory;
import cdc.args.FormalArg;
import cdc.args.FormalArgs;
import cdc.args.Necessity;
import cdc.converters.AbstractConverter;
import cdc.util.strings.StringUtils;

public final class StringFiller
extends AbstractConverter<String, String> {
    private final char fillChar;
    private final boolean preserveSpaces;
    public static final FormalArg<Character> FILL_CHAR = new FormalArg("fillChar", Character.TYPE, Necessity.MANDATORY);
    public static final FormalArg<Boolean> PRESERVE_SPACES = new FormalArg("preserveSpaces", Boolean.class, Necessity.OPTIONAL);
    public static final FormalArgs FPARAMS = new FormalArgs(new FormalArg[]{FILL_CHAR, PRESERVE_SPACES});
    public static final Factory<StringFiller> FACTORY = new AbstractFactory<StringFiller>(StringFiller.class, Args.builder().arg(SOURCE_CLASS, String.class).arg(TARGET_CLASS, String.class).build(), new FormalArgs[]{FPARAMS}){

        protected StringFiller create(Args args, FormalArgs fargs) {
            return StringFiller.create(((Character)args.getValue(FILL_CHAR)).charValue(), (Boolean)args.getValue(PRESERVE_SPACES, (Object)false));
        }
    };

    private StringFiller(char fillChar, boolean preserveSpaces) {
        super(String.class, String.class);
        this.fillChar = fillChar;
        this.preserveSpaces = preserveSpaces;
    }

    public static StringFiller create(char fillChar, boolean preserveSpaces) {
        return new StringFiller(fillChar, preserveSpaces);
    }

    public char getFillChar() {
        return this.fillChar;
    }

    public boolean getPreserveSpaces() {
        return this.preserveSpaces;
    }

    @Override
    public String apply(String source) {
        if (source == null) {
            return null;
        }
        return StringUtils.fillWithCharacter((String)source, (boolean)this.preserveSpaces, (char)this.fillChar);
    }

    @Override
    public Args getParams() {
        return Args.builder().arg(FILL_CHAR, (Object)Character.valueOf(this.getFillChar())).arg(PRESERVE_SPACES, (Object)this.getPreserveSpaces()).build();
    }
}

