/*
 * Decompiled with CFR 0.152.
 */
package cdc.converters.defaults;

import cdc.args.AbstractFactory;
import cdc.args.Args;
import cdc.args.Factory;
import cdc.args.FormalArg;
import cdc.args.FormalArgs;
import cdc.args.Necessity;
import cdc.converters.AbstractConverter;
import cdc.util.strings.StringUtils;

public final class StringRandomizer
extends AbstractConverter<String, String> {
    private final boolean preserveSpaces;
    public static final FormalArg<Boolean> PRESERVE_SPACES = new FormalArg("preserveSpaces", Boolean.class, Necessity.OPTIONAL);
    public static final FormalArgs FPARAMS = new FormalArgs(new FormalArg[]{PRESERVE_SPACES});
    public static final Factory<StringRandomizer> FACTORY = new AbstractFactory<StringRandomizer>(StringRandomizer.class, Args.builder().arg(SOURCE_CLASS, String.class).arg(TARGET_CLASS, String.class).build(), new FormalArgs[]{FPARAMS}){

        protected StringRandomizer create(Args args, FormalArgs fargs) {
            return StringRandomizer.create((Boolean)args.getValue(PRESERVE_SPACES, (Object)false));
        }
    };

    private StringRandomizer(boolean preserveSpaces) {
        super(String.class, String.class);
        this.preserveSpaces = preserveSpaces;
    }

    public static StringRandomizer create(boolean preserveSpaces) {
        return new StringRandomizer(preserveSpaces);
    }

    public boolean getPreserveSpaces() {
        return this.preserveSpaces;
    }

    @Override
    public String apply(String source) {
        if (source == null) {
            return null;
        }
        return StringUtils.scrambleWithLettersOrDigits((String)source, (boolean)this.preserveSpaces);
    }

    @Override
    public Args getParams() {
        return Args.builder().arg(PRESERVE_SPACES, (Object)this.getPreserveSpaces()).build();
    }
}

