/*
 * Decompiled with CFR 0.152.
 */
package cdc.converters.defaults;

import cdc.args.AbstractFactory;
import cdc.args.Args;
import cdc.args.Factory;
import cdc.args.FormalArg;
import cdc.args.FormalArgs;
import cdc.args.Necessity;
import cdc.converters.Converter;
import cdc.converters.defaults.AbstractSequenceConverter;
import cdc.converters.defaults.AbstractStringToSequence;
import cdc.util.lang.Checks;
import cdc.util.lang.Introspection;
import java.util.List;

public class StringToArray<T>
extends AbstractStringToSequence<T[]> {
    private final Converter<String, ? extends T> converter;
    private final Class<T> elementClass;
    public static final FormalArg<Converter<String, ?>> CONVERTER = new FormalArg("converter", Introspection.uncheckedCast(Converter.class), Necessity.MANDATORY);
    public static final FormalArgs FPARAMS = new FormalArgs(new FormalArg[]{PREFIX, SEPARATOR, SUFFIX, TRIM, CONVERTER});
    public static final Factory<StringToArray<?>> FACTORY = new AbstractFactory<StringToArray<?>>(Introspection.uncheckedCast(StringToArray.class), Args.builder().arg(SOURCE_CLASS, String.class).arg(TARGET_CLASS, Object[].class).build(), new FormalArgs[]{FPARAMS}){

        protected StringToArray<?> create(Args args, FormalArgs fargs) {
            String prefix = (String)args.getValue(AbstractSequenceConverter.PREFIX, null);
            String separator = (String)args.getValue(AbstractSequenceConverter.SEPARATOR, null);
            String suffix = (String)args.getValue(AbstractSequenceConverter.SUFFIX, null);
            boolean trim = (Boolean)args.getValue(AbstractStringToSequence.TRIM, (Object)false);
            Converter converter = (Converter)Introspection.uncheckedCast((Object)args.getValue(CONVERTER));
            Class elementClass = converter.getWrappedTargetClass();
            return StringToArray.create(elementClass, prefix, separator, suffix, converter, trim);
        }
    };

    protected static <C extends StringToArray<T>, T> Factory<C> factory(Class<C> converterClass, final Class<T> elementClass, final Creator<C, T> creator) {
        return new AbstractFactory<C>(converterClass, Args.builder().arg(SOURCE_CLASS, String.class).arg(TARGET_CLASS, (Object)Introspection.getArrayClass(elementClass)).build(), new FormalArgs[]{FPARAMS}){

            protected C create(Args args, FormalArgs fargs) {
                String prefix = (String)args.getValue(AbstractSequenceConverter.PREFIX, null);
                String separator = (String)args.getValue(AbstractSequenceConverter.SEPARATOR, null);
                String suffix = (String)args.getValue(AbstractSequenceConverter.SUFFIX, null);
                Converter converter = (Converter)Introspection.uncheckedCast((Object)args.getValue(CONVERTER));
                boolean trim = (Boolean)args.getValue(AbstractStringToSequence.TRIM, (Object)false);
                Checks.isTrue((boolean)converter.isCompliantTargetClass(elementClass), (String)"Non compliant converter");
                return (StringToArray)creator.create(prefix, separator, suffix, converter, trim);
            }
        };
    }

    public StringToArray(Class<T> elementClass, String prefix, String separator, String suffix, Converter<String, ? extends T> converter, boolean trim) {
        super(Introspection.getArrayClass(elementClass), prefix, separator, suffix, trim);
        Checks.isNotNull(converter, (String)"converter");
        this.converter = converter;
        this.elementClass = elementClass;
    }

    public static <T> StringToArray<T> create(Class<T> elementClass, String prefix, String separator, String suffix, Converter<String, ? extends T> converter, boolean trim) {
        return new StringToArray<T>(elementClass, prefix, separator, suffix, converter, trim);
    }

    public final Converter<String, ? extends T> getConverter() {
        return this.converter;
    }

    public final Class<T> getElementClass() {
        return this.elementClass;
    }

    @Override
    public T[] apply(String s) {
        List<Object> list = this.toList(s, this.converter);
        return list.toArray(Introspection.newArray(this.getElementClass(), (int)list.size()));
    }

    @Override
    public Args getParams() {
        return Args.builder().arg(PREFIX, (Object)this.getPrefix()).arg(SEPARATOR, (Object)this.getSeparator()).arg(SUFFIX, (Object)this.getSuffix()).arg(TRIM, (Object)this.getTrim()).arg(CONVERTER, this.getConverter()).build();
    }

    @FunctionalInterface
    protected static interface Creator<C, T> {
        public C create(String var1, String var2, String var3, Converter<String, ? extends T> var4, boolean var5);
    }
}

