/*
 * Decompiled with CFR 0.152.
 */
package cdc.converters.defaults;

import cdc.args.AbstractFactory;
import cdc.args.Args;
import cdc.args.Factory;
import cdc.args.FormalArg;
import cdc.args.FormalArgs;
import cdc.converters.AbstractConverter;
import cdc.converters.ConversionException;
import cdc.converters.defaults.DateConversionSupport;
import cdc.util.lang.Checks;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;

public final class StringToDate
extends AbstractConverter<String, Date> {
    private final DateFormat format;
    private final String pattern;
    private final Locale locale;
    private static final Default[] DEFAULTS = new Default[]{new Default("yyyy-MM-dd HH:mm:ss.SSS", "[0-9]{4}[-][0-9]{2}[-][0-9]{2}[ ][0-9]{2}[:][0-9]{2}[:][0-9]{2}[.][0-9]{3}"), new Default("yyyy/MM/dd HH:mm:ss.SSS", "[0-9]{4}[/][0-9]{2}[/][0-9]{2}[ ][0-9]{2}[:][0-9]{2}[:][0-9]{2}[.][0-9]{3}"), new Default("dd-MM-yyyy HH:mm:ss.SSS", "[0-9]{2}[-][0-9]{2}[-][0-9]{4}[ ][0-9]{2}[:][0-9]{2}[:][0-9]{2}[.][0-9]{3}"), new Default("dd/MM/yyyy HH:mm:ss.SSS", "[0-9]{2}[/][0-9]{2}[/][0-9]{4}[ ][0-9]{2}[:][0-9]{2}[:][0-9]{2}[.][0-9]{3}"), new Default("yyyy-MM-dd HH:mm:ss", "[0-9]{4}[-][0-9]{2}[-][0-9]{2}[ ][0-9]{2}[:][0-9]{2}[:][0-9]{2}"), new Default("yyyy/MM/dd HH:mm:ss", "[0-9]{4}[/][0-9]{2}[/][0-9]{2}[ ][0-9]{2}[:][0-9]{2}[:][0-9]{2}"), new Default("dd-MM-yyyy HH:mm:ss", "[0-9]{2}[-][0-9]{2}[-][0-9]{4}[ ][0-9]{2}[:][0-9]{2}[:][0-9]{2}"), new Default("dd/MM/yyyy HH:mm:ss", "[0-9]{2}[/][0-9]{2}[/][0-9]{4}[ ][0-9]{2}[:][0-9]{2}[:][0-9]{2}"), new Default("yyyy-MM-dd HH:mm", "[0-9]{4}[-][0-9]{2}[-][0-9]{2}[ ][0-9]{2}[:][0-9]{2}"), new Default("yyyy/MM/dd HH:mm", "[0-9]{4}[/][0-9]{2}[/][0-9]{2}[ ][0-9]{2}[:][0-9]{2}"), new Default("dd-MM-yyyy HH:mm", "[0-9]{2}[-][0-9]{2}[-][0-9]{4}[ ][0-9]{2}[:][0-9]{2}"), new Default("dd/MM/yyyy HH:mm", "[0-9]{2}[/][0-9]{2}[/][0-9]{4}[ ][0-9]{2}[:][0-9]{2}"), new Default("yyyy-MM-dd", "[0-9]{4}[-][0-9]{2}[-][0-9]{2}"), new Default("yyyy/MM/dd", "[0-9]{4}[/][0-9]{2}[/][0-9]{2}"), new Default("dd-MM-yyyy", "[0-9]{2}[-][0-9]{2}[-][0-9]{4}"), new Default("dd/MM/yyyy", "[0-9]{2}[/][0-9]{2}[/][0-9]{4}"), new Default("HH:mm:ss.SSS", "[0-9]{2}[:][0-9]{2}[:][0-9]{2}[.][0-9]{3}"), new Default("HH:mm:ss", "[0-9]{2}[:][0-9]{2}[:][0-9]{2}"), new Default("HH:mm", "[0-9]{2}[:][0-9]{2}")};
    public static final StringToDate AUTO = new StringToDate();
    public static final StringToDate DASH_YYYY_MM_DD = StringToDate.create("yyyy-MM-dd", null);
    public static final StringToDate SLASH_YYYY_MM_DD = StringToDate.create("yyyy/MM/dd", null);
    public static final StringToDate DASH_DD_MM_YYYY = StringToDate.create("dd-MM-yyyy", null);
    public static final StringToDate SLASH_DD_MM_YYYY = StringToDate.create("dd/MM/yyyy", null);
    public static final StringToDate HH_MM_SS = StringToDate.create("HH:mm:ss", null);
    public static final StringToDate DASH_YYYY_MM_DD_HH_MM_SS = StringToDate.create("yyyy-MM-dd HH:mm:ss", null);
    public static final StringToDate SLASH_YYYY_MM_DD_HH_MM_SS = StringToDate.create("yyyy/MM/dd HH:mm:ss", null);
    public static final StringToDate DASH_DD_MM_YYYY_HH_MM_SS = StringToDate.create("dd-MM-yyyy HH:mm:ss", null);
    public static final StringToDate SLASH_DD_MM_YYYY_HH_MM_SS = StringToDate.create("dd/MM/yyyy HH:mm:ss", null);
    public static final FormalArg<DateFormat> FORMAT = DateConversionSupport.FORMAT;
    public static final FormalArgs FPARAMS_FORMAT = DateConversionSupport.FPARAMS_FORMAT;
    public static final FormalArg<String> PATTERN = DateConversionSupport.PATTERN;
    public static final FormalArg<Locale> LOCALE = DateConversionSupport.LOCALE;
    public static final FormalArgs FPARAMS_PATTERN_LOCALE = DateConversionSupport.FPARAMS_PATTERN_LOCALE;
    public static final Factory<StringToDate> FACTORY = new AbstractFactory<StringToDate>(StringToDate.class, Args.builder().arg(SOURCE_CLASS, String.class).arg(TARGET_CLASS, Date.class).build(), new FormalArgs[]{FormalArgs.NO_FARGS, FPARAMS_PATTERN_LOCALE, FPARAMS_FORMAT}){

        protected StringToDate create(Args args, FormalArgs fargs) {
            if (fargs == FPARAMS_FORMAT) {
                DateFormat vformat = (DateFormat)args.getValue(FORMAT);
                return StringToDate.create(vformat);
            }
            if (fargs == FPARAMS_PATTERN_LOCALE) {
                String vpattern = (String)args.getValue(PATTERN);
                Locale vlocale = (Locale)args.getValue(LOCALE, null);
                return StringToDate.create(vpattern, vlocale);
            }
            return AUTO;
        }
    };

    private StringToDate() {
        super(String.class, Date.class);
        this.format = null;
        this.pattern = null;
        this.locale = null;
    }

    private StringToDate(DateFormat format, String pattern, Locale locale) {
        super(String.class, Date.class);
        Checks.isNotNull((Object)format, (String)"format");
        this.format = format;
        this.pattern = pattern;
        this.locale = locale;
    }

    public static StringToDate create(DateFormat format) {
        return new StringToDate(format, null, null);
    }

    public static StringToDate create(String pattern, Locale locale) {
        SimpleDateFormat format = locale == null ? new SimpleDateFormat(pattern) : new SimpleDateFormat(pattern, locale);
        format.setLenient(false);
        return new StringToDate(format, pattern, locale);
    }

    public DateFormat getFormat() {
        return this.format;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Locale getLocale() {
        return this.locale;
    }

    private static Date convert(String source, DateFormat format) {
        try {
            return format.parse(source);
        }
        catch (ParseException e) {
            throw new ConversionException("Failed to parse '" + source + "' using " + format, e);
        }
    }

    @Override
    public Date apply(String source) {
        if (source == null || source.isEmpty()) {
            return null;
        }
        if (this.format == null) {
            for (Default def : DEFAULTS) {
                if (!def.pattern.matcher(source).find()) continue;
                return StringToDate.convert(source, def.format);
            }
            throw new ConversionException("Failed to parse '" + source + "' using default formats");
        }
        return StringToDate.convert(source, this.format);
    }

    @Override
    public Args getParams() {
        if (this.format == null) {
            return Args.NO_ARGS;
        }
        if (this.pattern == null) {
            return Args.builder((FormalArgs)FPARAMS_FORMAT).arg(FORMAT, (Object)this.getFormat()).build();
        }
        return Args.builder((FormalArgs)FPARAMS_PATTERN_LOCALE).arg(PATTERN, (Object)this.getPattern()).arg(LOCALE, (Object)this.getLocale()).build();
    }

    private static class Default {
        final SimpleDateFormat format;
        final Pattern pattern;

        public Default(String pattern, String regex) {
            this.format = new SimpleDateFormat(pattern);
            this.pattern = Pattern.compile(regex);
        }
    }
}

