/*
 * Decompiled with CFR 0.152.
 */
package cdc.converters.defaults;

import cdc.args.Factory;
import cdc.converters.defaults.AbstractStringToTemporal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public final class StringToLocalDate
extends AbstractStringToTemporal<LocalDate> {
    private static final AbstractStringToTemporal.Default[] DEFAULTS = new AbstractStringToTemporal.Default[]{new AbstractStringToTemporal.Default("yyyy-MM-dd"), new AbstractStringToTemporal.Default("yyyy/MM/dd"), new AbstractStringToTemporal.Default("dd-MM-yyyy"), new AbstractStringToTemporal.Default("dd/MM/yyyy")};
    public static final StringToLocalDate AUTO = new StringToLocalDate();
    public static final StringToLocalDate BASIC_ISO_DATE = StringToLocalDate.create(DateTimeFormatter.BASIC_ISO_DATE);
    public static final StringToLocalDate ISO_DATE = StringToLocalDate.create(DateTimeFormatter.ISO_DATE);
    public static final StringToLocalDate ISO_LOCAL_DATE = StringToLocalDate.create(DateTimeFormatter.ISO_LOCAL_DATE);
    public static final StringToLocalDate DASH_YYYY_MM_DD = StringToLocalDate.create("yyyy-MM-dd", null);
    public static final StringToLocalDate SLASH_YYYY_MM_DD = StringToLocalDate.create("yyyy/MM/dd", null);
    public static final StringToLocalDate DASH_DD_MM_YYYY = StringToLocalDate.create("dd-MM-yyyy", null);
    public static final StringToLocalDate SLASH_DD_MM_YYYY = StringToLocalDate.create("dd/MM/yyyy", null);
    public static final Factory<StringToLocalDate> FACTORY = StringToLocalDate.factory(StringToLocalDate.class, LocalDate.class, null, StringToLocalDate::create, StringToLocalDate::create);

    private StringToLocalDate() {
        super(LocalDate.class);
    }

    private StringToLocalDate(DateTimeFormatter formatter, String pattern, Locale locale) {
        super(LocalDate.class, formatter, pattern, locale);
    }

    public static StringToLocalDate create(DateTimeFormatter formatter) {
        return new StringToLocalDate(formatter, null, null);
    }

    public static StringToLocalDate create(String pattern, Locale locale) {
        DateTimeFormatter formatter = locale == null ? DateTimeFormatter.ofPattern(pattern) : DateTimeFormatter.ofPattern(pattern, locale);
        return new StringToLocalDate(formatter, pattern, locale);
    }

    @Override
    public final LocalDate apply(String source) {
        return this.apply(source, LocalDate::parse, DEFAULTS);
    }
}

