/*
 * Decompiled with CFR 0.152.
 */
package cdc.converters.defaults;

import cdc.args.Factory;
import cdc.converters.defaults.AbstractStringToTemporal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public final class StringToLocalDateTime
extends AbstractStringToTemporal<LocalDateTime> {
    private static final AbstractStringToTemporal.Default[] DEFAULTS = new AbstractStringToTemporal.Default[]{new AbstractStringToTemporal.Default("yyyy-MM-dd HH:mm:ss.SSS"), new AbstractStringToTemporal.Default("yyyy/MM/dd HH:mm:ss.SSS"), new AbstractStringToTemporal.Default("dd-MM-yyyy HH:mm:ss.SSS"), new AbstractStringToTemporal.Default("dd/MM/yyyy HH:mm:ss.SSS"), new AbstractStringToTemporal.Default("yyyy-MM-dd HH:mm:ss"), new AbstractStringToTemporal.Default("yyyy/MM/dd HH:mm:ss"), new AbstractStringToTemporal.Default("dd-MM-yyyy HH:mm:ss"), new AbstractStringToTemporal.Default("dd/MM/yyyy HH:mm:ss"), new AbstractStringToTemporal.Default("yyyy-MM-dd HH:mm"), new AbstractStringToTemporal.Default("yyyy/MM/dd HH:mm"), new AbstractStringToTemporal.Default("dd-MM-yyyy HH:mm"), new AbstractStringToTemporal.Default("dd/MM/yyyy HH:mm")};
    public static final StringToLocalDateTime AUTO = new StringToLocalDateTime();
    public static final StringToLocalDateTime ISO_DATE_TIME = StringToLocalDateTime.create(DateTimeFormatter.ISO_DATE_TIME);
    public static final Factory<StringToLocalDateTime> FACTORY = StringToLocalDateTime.factory(StringToLocalDateTime.class, LocalDateTime.class, AUTO, StringToLocalDateTime::create, StringToLocalDateTime::create);

    private StringToLocalDateTime() {
        super(LocalDateTime.class);
    }

    private StringToLocalDateTime(DateTimeFormatter formatter, String pattern, Locale locale) {
        super(LocalDateTime.class, formatter, pattern, locale);
    }

    public static StringToLocalDateTime create(DateTimeFormatter formatter) {
        return new StringToLocalDateTime(formatter, null, null);
    }

    public static StringToLocalDateTime create(String pattern, Locale locale) {
        DateTimeFormatter formatter = locale == null ? DateTimeFormatter.ofPattern(pattern) : DateTimeFormatter.ofPattern(pattern, locale);
        return new StringToLocalDateTime(formatter, pattern, locale);
    }

    @Override
    public final LocalDateTime apply(String source) {
        return this.apply(source, LocalDateTime::parse, DEFAULTS);
    }
}

