/*
 * Decompiled with CFR 0.152.
 */
package cdc.converters.defaults;

import cdc.args.Factory;
import cdc.converters.defaults.AbstractStringToTemporal;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public final class StringToLocalTime
extends AbstractStringToTemporal<LocalTime> {
    private static final AbstractStringToTemporal.Default[] DEFAULTS = new AbstractStringToTemporal.Default[]{new AbstractStringToTemporal.Default("HH:mm:ss.SSS"), new AbstractStringToTemporal.Default("HH:mm:ss"), new AbstractStringToTemporal.Default("HH:mm")};
    public static final StringToLocalTime AUTO = new StringToLocalTime();
    public static final StringToLocalTime ISO_LOCAL_TIME = StringToLocalTime.create(DateTimeFormatter.ISO_LOCAL_TIME);
    public static final StringToLocalTime ISO_TIME = StringToLocalTime.create(DateTimeFormatter.ISO_TIME);
    public static final StringToLocalTime HH_MM_SS = StringToLocalTime.create("HH:mm:ss", null);
    public static final Factory<StringToLocalTime> FACTORY = StringToLocalTime.factory(StringToLocalTime.class, LocalTime.class, null, StringToLocalTime::create, StringToLocalTime::create);

    private StringToLocalTime() {
        super(LocalTime.class);
    }

    private StringToLocalTime(DateTimeFormatter formatter, String pattern, Locale locale) {
        super(LocalTime.class, formatter, pattern, locale);
    }

    public static StringToLocalTime create(DateTimeFormatter formatter) {
        return new StringToLocalTime(formatter, null, null);
    }

    public static StringToLocalTime create(String pattern, Locale locale) {
        DateTimeFormatter formatter = locale == null ? DateTimeFormatter.ofPattern(pattern) : DateTimeFormatter.ofPattern(pattern, locale);
        return new StringToLocalTime(formatter, pattern, locale);
    }

    @Override
    public final LocalTime apply(String source) {
        return this.apply(source, LocalTime::parse, DEFAULTS);
    }
}

