/*
 * Decompiled with CFR 0.152.
 */
package cdc.kernel.demos;

import cdc.args.Factories;
import cdc.args.Factory;
import cdc.converters.ArgsConversion;
import cdc.converters.Converters;
import cdc.informers.Informer;
import cdc.informers.Informers;
import cdc.informers.StringConversionInformer;
import cdc.informers.io.InformersIo;
import cdc.io.data.xml.XmlDataReader;
import cdc.util.lang.FailureReaction;
import cdc.util.lang.Introspection;
import cdc.util.strings.StringConversion;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.io.IoBuilder;

public final class InformersIoDemo {
    private static final Logger LOGGER = LogManager.getLogger(InformersIoDemo.class);
    private static final PrintStream OUT = IoBuilder.forLogger((Logger)LOGGER).setLevel(Level.INFO).buildPrintStream();

    private InformersIoDemo() {
    }

    private static <O, T extends Informer<O>> void show(Class<O> objectClass, Class<T> topic) {
        Informer informer;
        LOGGER.info("show({}, {}):", (Object)objectClass.getSimpleName(), (Object)topic.getSimpleName());
        try {
            informer = Informers.getInformer(objectClass, topic, (FailureReaction)FailureReaction.DEFAULT);
            LOGGER.info("   exact: {}", (Object)Informer.toString((Informer)informer));
        }
        catch (RuntimeException e) {
            LOGGER.info("   exact: NONE");
        }
        try {
            informer = Informers.getBestInformer(objectClass, topic, (FailureReaction)FailureReaction.DEFAULT);
            LOGGER.info("   best: {}", (Object)Informer.toString((Informer)informer));
        }
        catch (RuntimeException e) {
            LOGGER.info("   best: NONE");
        }
    }

    private static void convert(Object object) {
        try {
            String s = StringConversionInformer.Service.toString((Object)object);
            LOGGER.info("convert({}): {}", object, (Object)s);
        }
        catch (RuntimeException e) {
            LOGGER.info("convert({}): FAILED", object);
        }
    }

    public static void main(String[] args) throws IOException {
        Converters.elaborate();
        Factories.setConverter(ArgsConversion::convert);
        InformersIo.DataLoader loader = new InformersIo.DataLoader(FailureReaction.WARN);
        loader.loadXml("src/test/resources/informers.xml", new XmlDataReader.Feature[0]);
        Informers.register((Informer)AInformer.INSTANCE);
        Informers.PRINTER.print(OUT);
        InformersIoDemo.show(Integer.class, Introspection.uncheckedCast(StringConversionInformer.class));
        InformersIoDemo.show(Float.class, Introspection.uncheckedCast(StringConversionInformer.class));
        InformersIoDemo.show(A.class, Introspection.uncheckedCast(StringConversionInformer.class));
        InformersIoDemo.show(B.class, Introspection.uncheckedCast(StringConversionInformer.class));
        InformersIoDemo.convert(10);
        InformersIoDemo.convert(10.0);
    }

    protected static class DemoInformer
    implements StringConversionInformer<Integer> {
        public static final DemoInformer INSTANCE = new DemoInformer();
        public static final Factory<DemoInformer> FACTORY = Factory.singleton((Object)INSTANCE);

        private DemoInformer() {
        }

        public Class<Integer> getObjectClass() {
            return Integer.class;
        }

        public String toString(Integer object) {
            return StringConversion.asString((Integer)object);
        }

        public Integer fromString(String s) {
            return StringConversion.asOptionalInt((String)s);
        }
    }

    protected static class B
    extends A {
        protected B() {
        }
    }

    protected static class AInformer
    implements StringConversionInformer<A> {
        public static final AInformer INSTANCE = new AInformer();
        public static final Factory<AInformer> FACTORY = Factory.singleton((Object)INSTANCE);

        private AInformer() {
        }

        public Class<A> getObjectClass() {
            return A.class;
        }

        public String toString(A object) {
            return null;
        }

        public A fromString(String s) {
            return null;
        }
    }

    protected static class A {
        protected A() {
        }
    }
}

