/*
 * Decompiled with CFR 0.152.
 */
package cdc.kernel.demos;

import cdc.args.Factories;
import cdc.converters.ArgsConversion;
import cdc.converters.Converter;
import cdc.converters.Converters;
import cdc.converters.SpecialConverterKind;
import cdc.converters.io.ConvertersIo;
import cdc.io.data.xml.XmlDataReader;
import cdc.io.xml.XmlWriter;
import cdc.util.function.IterableUtils;
import cdc.util.lang.FailureReaction;
import cdc.util.time.Chronometer;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ConvertersIoDemo {
    private static final Logger LOGGER = LogManager.getLogger(ConvertersIoDemo.class);
    protected static boolean useDataLoader = true;

    private ConvertersIoDemo() {
    }

    private static String special(Converter<?, ?> converter) {
        return (Converters.isSpecialConverter(converter, (SpecialConverterKind)SpecialConverterKind.DEFAULT) ? "D" : " ") + (Converters.isSpecialConverter(converter, (SpecialConverterKind)SpecialConverterKind.DEFAULT_OR_SINGLE) ? "S" : " ");
    }

    public static void main(String[] args) throws IOException {
        Converters.elaborate();
        Factories.setConverter(ArgsConversion::convert);
        Chronometer chrono = new Chronometer();
        chrono.start();
        if (useDataLoader) {
            loader = new ConvertersIo.DataLoader(FailureReaction.WARN);
            loader.loadXml("src/test/resources/converters.xml", new XmlDataReader.Feature[0]);
        } else {
            loader = new ConvertersIo.StAXLoader(FailureReaction.WARN);
            loader.load("src/test/resources/converters.xml");
        }
        chrono.suspend();
        LOGGER.info("elapsed: {}", (Object)chrono);
        LOGGER.info("===================================================");
        for (String name : IterableUtils.toSortedList((Iterable)Converters.getNames())) {
            if (!name.startsWith("Demo")) continue;
            Converter converter = Converters.getConverter((String)name);
            LOGGER.info("{} {}: {}", (Object)ConvertersIoDemo.special(converter), (Object)name, (Object)converter);
            StringWriter buffer = new StringWriter();
            XmlWriter writer = new XmlWriter((Writer)buffer);
            writer.setEnabled(new XmlWriter.Feature[]{XmlWriter.Feature.ALLOW_PARTIAL_XML, XmlWriter.Feature.PRETTY_PRINT});
            ConvertersIo.write((XmlWriter)writer, (Converter)converter);
            LOGGER.info("converter:\n{}", (Object)buffer.toString());
        }
    }
}

