/*
 * Decompiled with CFR 0.152.
 */
package cdc.enums;

import cdc.enums.EnumTypes;
import cdc.enums.ListType;
import cdc.enums.Mask;
import cdc.enums.MaskSupport;
import cdc.enums.Nullable;
import cdc.util.function.IterableUtils;
import cdc.util.function.Predicates;
import cdc.util.lang.Checks;
import cdc.util.lang.CollectionUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;

public class AbstractMask<M extends AbstractMask<M, V>, V>
implements Mask<M, V> {
    protected final MaskSupport<M, V> support;
    protected final Set<V> values;

    protected AbstractMask(MaskSupport<M, V> support, Set<V> values) {
        this.support = support;
        this.values = Collections.unmodifiableSet(values);
        this.checkValues();
    }

    protected static <M extends AbstractMask<M, V>, V> MaskSupport<M, V> support(Class<M> maskClass, Creator<M, V> creator, ListType<V> type, Nullable nullable) {
        Checks.isNotNull(maskClass, (String)"maskClass");
        Checks.isNotNull(creator, (String)"creator");
        Checks.isNotNull(type, (String)"type");
        Checks.isNotNull((Object)((Object)nullable), (String)"nullable");
        return new SupportImpl<M, V>(maskClass, creator, type, nullable, HashSet::new);
    }

    protected static <M extends AbstractMask<M, V>, V extends Enum<V>> MaskSupport<M, V> support(Class<M> maskClass, Creator<M, V> creator, Class<V> enumClass, Nullable nullable) {
        Checks.isNotNull(maskClass, (String)"maskClass");
        Checks.isNotNull(creator, (String)"creator");
        Checks.isNotNull(enumClass, (String)"enumClass");
        Checks.isNotNull((Object)((Object)nullable), (String)"nullable");
        return new SupportImpl<M, V>(maskClass, creator, EnumTypes.getEnumType(enumClass), nullable, nullable.isTrue() ? HashSet::new : s -> EnumSet.noneOf(enumClass));
    }

    private Set<V> newSet(Collection<V> values) {
        Set<V> result = this.support.newSet(values.size());
        result.addAll(values);
        return result;
    }

    private void checkValue(V value) {
        Checks.isTrue((value != null || this.isNullable() ? 1 : 0) != 0, (String)"null is not supported");
    }

    private void checkOther(M other) {
        Checks.isNotNull(other, (String)"other");
        Checks.isTrue((this.support.isNullable() == ((AbstractMask)other).support.isNullable() ? 1 : 0) != 0, (String)"Cannot mix masks with different nullable");
    }

    private void checkValues() {
        Checks.isTrue((this.isNullable() || !this.values.contains(null) ? 1 : 0) != 0, (String)"null is not supported");
    }

    @Override
    public MaskSupport<M, V> getSupport() {
        return this.support;
    }

    @Override
    public boolean isNullable() {
        return this.support.isNullable();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean isFull() {
        if (this.values.size() != this.support.getType().getValues().size() + (this.isNullable() ? 1 : 0)) {
            return false;
        }
        return this.equals(this.full());
    }

    @Override
    public Set<V> getValues() {
        return this.values;
    }

    @Override
    public boolean isSet(V value) {
        this.checkValue(value);
        return this.values.contains(value);
    }

    @Override
    public boolean isClear(V value) {
        this.checkValue(value);
        return !this.values.contains(value);
    }

    @Override
    public M set(V value, boolean enabled) {
        this.checkValue(value);
        return (M)(enabled ? this.set((Object)value) : this.clear((Object)value));
    }

    @Override
    public M set(V value) {
        this.checkValue(value);
        if (this.isSet(value)) {
            return (M)((AbstractMask)this.support.getMaskClass().cast(this));
        }
        Set<V> tmp = this.newSet(this.values);
        tmp.add(value);
        return (M)((AbstractMask)this.support.create((Iterable<V>)tmp));
    }

    @Override
    public M clear(V value) {
        this.checkValue(value);
        if (this.isSet(value)) {
            Set<V> tmp = this.newSet(this.values);
            tmp.remove(value);
            return (M)((AbstractMask)this.support.create((Iterable<V>)tmp));
        }
        return (M)((AbstractMask)this.support.getMaskClass().cast(this));
    }

    @Override
    public M setAll(boolean enabled) {
        return (M)((AbstractMask)this.support.create(enabled));
    }

    @Override
    public M empty() {
        return (M)this.setAll(false);
    }

    @Override
    public M full() {
        return (M)this.setAll(true);
    }

    @Override
    public M and(M other) {
        this.checkOther(other);
        if (this.values.size() <= ((AbstractMask)other).values.size()) {
            Set<V> tmp = this.newSet(this.values);
            tmp.retainAll(((AbstractMask)other).values);
            return (M)((AbstractMask)this.support.create((Iterable<V>)tmp));
        }
        Set<V> tmp = this.newSet(((AbstractMask)other).values);
        tmp.retainAll(this.values);
        return (M)((AbstractMask)this.support.create((Iterable<V>)tmp));
    }

    @Override
    public M and(V value) {
        if (this.contains(new Object[]{value})) {
            return (M)((AbstractMask)this.support.create(value));
        }
        return (M)this.empty();
    }

    @Override
    public M and(V ... values) {
        if (values.length == 0) {
            return (M)((AbstractMask)this.support.empty());
        }
        AbstractMask other = (AbstractMask)this.support.create(values);
        return this.and((V)other);
    }

    @Override
    public M or(M other) {
        this.checkOther(other);
        if (((AbstractMask)other).isEmpty()) {
            return (M)((AbstractMask)this.support.getMaskClass().cast(this));
        }
        if (this.isEmpty()) {
            return other;
        }
        Set<V> tmp = this.newSet(this.values);
        tmp.addAll(((AbstractMask)other).values);
        return (M)((AbstractMask)this.support.create((Iterable<V>)tmp));
    }

    @Override
    public M or(V value) {
        if (this.contains(new Object[]{value})) {
            return (M)((AbstractMask)this.support.getMaskClass().cast(this));
        }
        AbstractMask other = (AbstractMask)this.support.create(value);
        return this.or((V)other);
    }

    @Override
    public M or(V ... values) {
        if (values.length == 0) {
            return (M)((AbstractMask)this.support.getMaskClass().cast(this));
        }
        AbstractMask other = (AbstractMask)this.support.create(values);
        return this.or((V)other);
    }

    @Override
    public M not() {
        Set<V> tmp = this.newSet(this.support.getType().getValues());
        if (this.support.isNullable()) {
            tmp.add(null);
        }
        tmp.removeAll(this.values);
        return (M)((AbstractMask)this.support.create((Iterable<V>)tmp));
    }

    @Override
    public final boolean contains(M other) {
        this.checkOther(other);
        return ((AbstractMask)this.and((V)other)).equals(other);
    }

    @Override
    @SafeVarargs
    public final boolean contains(V ... values) {
        if (values.length == 0) {
            return true;
        }
        AbstractMask other = (AbstractMask)this.support.create(values);
        return this.contains((M)other);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!this.support.getMaskClass().isInstance(other)) {
            return false;
        }
        AbstractMask o = (AbstractMask)this.support.getMaskClass().cast(other);
        return this.support.getType().equals(o.support.getType()) && this.support.isNullable() == o.support.isNullable() && this.values.equals(o.values);
    }

    public int hashCode() {
        return this.support.getType().hashCode() + (this.support.isNullable() ? 1 : 0) + this.values.hashCode();
    }

    @Override
    public String toString(Function<? super V, String> valueToString, String separator) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (V value : this.getSupport().getType().getValues()) {
            if (!this.isSet(value)) continue;
            if (first) {
                first = false;
            } else {
                builder.append(separator);
            }
            builder.append(valueToString.apply(value));
        }
        if (this.isNullable() && this.isSet(null)) {
            if (!first) {
                builder.append(separator);
            }
            builder.append(valueToString.apply(null));
        }
        return builder.toString();
    }

    public String toString() {
        return this.toString(o -> o == null ? "null" : o.toString(), "|");
    }

    private static final class SupportImpl<M extends AbstractMask<M, V>, V>
    implements MaskSupport<M, V> {
        public final Class<M> cls;
        private final Creator<M, V> creator;
        private final ListType<V> type;
        private final Nullable nullable;
        private final IntFunction<Set<V>> newSet;
        private final M empty;

        public SupportImpl(Class<M> cls, Creator<M, V> creator, ListType<V> type, Nullable nullable, IntFunction<Set<V>> newSet) {
            this.cls = cls;
            this.creator = creator;
            this.type = type;
            this.nullable = nullable;
            this.empty = (AbstractMask)creator.create(this, Collections.emptySet());
            this.newSet = newSet;
        }

        @Override
        public Class<M> getMaskClass() {
            return this.cls;
        }

        @Override
        public ListType<V> getType() {
            return this.type;
        }

        @Override
        public boolean isNullable() {
            return this.nullable == Nullable.TRUE;
        }

        @Override
        public M empty() {
            return this.empty;
        }

        @Override
        public M full() {
            return (M)this.create(Predicates.alwaysTrue());
        }

        @Override
        public M create() {
            return this.empty;
        }

        @Override
        public M create(V value) {
            return (M)((AbstractMask)this.creator.create(this, CollectionUtils.toSet((Object[])new Object[]{value})));
        }

        @Override
        public M create(V ... values) {
            return (M)((AbstractMask)this.creator.create(this, CollectionUtils.toSet((Object[])values)));
        }

        @Override
        public M create(Iterable<V> values) {
            return (M)((AbstractMask)this.creator.create(this, IterableUtils.toSet(values)));
        }

        @Override
        public M create(Predicate<V> predicate) {
            Set values = this.nullable.isTrue() ? IterableUtils.toUnmodifiableSet((Iterable)IterableUtils.join(this.type.getValues(), null), predicate) : IterableUtils.toUnmodifiableSet(this.type.getValues(), predicate);
            return (M)((AbstractMask)this.creator.create(this, values));
        }

        @Override
        public M create(boolean enabled) {
            return (M)this.create(enabled ? Predicates.alwaysTrue() : Predicates.alwaysFalse());
        }

        @Override
        public Set<V> newSet(int size) {
            return this.newSet.apply(size);
        }
    }

    @FunctionalInterface
    protected static interface Creator<M extends Mask<M, V>, V> {
        public M create(MaskSupport<M, V> var1, Set<V> var2);
    }
}

