/*
 * Decompiled with CFR 0.152.
 */
package cdc.enums;

import cdc.enums.DagEventHandler;
import cdc.enums.DagFeature;
import cdc.enums.EnumType;
import cdc.util.lang.Checks;
import cdc.util.lang.FailureReaction;
import cdc.util.lang.NotFoundException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class EnumTypes {
    protected static final Logger LOGGER = LogManager.getLogger(EnumTypes.class);
    private static final Map<Class<? extends Enum<?>>, StandardEnumType> MAP = new HashMap();

    private EnumTypes() {
    }

    public static <E extends Enum<E>> EnumType<E> getEnumType(Class<E> enumClass) {
        StandardEnumType tmp;
        StandardEnumType result = tmp = MAP.computeIfAbsent(enumClass, k -> new StandardEnumType((Class<Enum<?>>)k));
        return result;
    }

    public static Set<Class<? extends Enum<?>>> getEnumClasses() {
        return MAP.keySet();
    }

    private static class StandardEnumType
    implements EnumType<Enum<?>> {
        private final Class<Enum<?>> valueClass;
        private final List<Enum<?>> values;
        private final Map<String, Enum<?>> nameToValue;

        public StandardEnumType(Class<Enum<?>> valueClass) {
            Checks.isNotNull(valueClass, (String)"valueClass");
            this.valueClass = valueClass;
            this.values = Collections.unmodifiableList(Arrays.asList(valueClass.getEnumConstants()));
            this.nameToValue = new HashMap();
            for (Enum<?> value : this.values) {
                this.nameToValue.put(value.name(), value);
            }
        }

        @Override
        public void addEventHandler(DagEventHandler handler) {
        }

        @Override
        public void removeEventHandler(DagEventHandler handler) {
        }

        @Override
        public boolean isSupported(DagFeature feature) {
            return false;
        }

        @Override
        public boolean isLocked() {
            return true;
        }

        @Override
        public Class<Enum<?>> getValueClass() {
            return this.valueClass;
        }

        @Override
        public List<Enum<?>> getValues() {
            return this.values;
        }

        @Override
        public List<Enum<?>> getRoots() {
            return this.getValues();
        }

        @Override
        public List<Enum<?>> getChildren(Enum<?> value) {
            return Collections.emptyList();
        }

        @Override
        public List<Enum<?>> getParents(Enum<?> value) {
            return Collections.emptyList();
        }

        @Override
        public String getName(Enum<?> value) {
            return value == null ? null : value.name();
        }

        @Override
        public String getQName(Enum<?> value) {
            return this.getName(value);
        }

        @Override
        public boolean isValid(Enum<?> value) {
            return value != null;
        }

        @Override
        public Enum<?> valueOf(String qname, FailureReaction reaction) {
            return (Enum)NotFoundException.onResult(this.nameToValue.get(qname), (String)EnumType.unknownQName(qname), (Logger)LOGGER, (FailureReaction)reaction, null);
        }

        @Override
        public boolean areEqual(Enum<?> left, Enum<?> right) {
            return left == right;
        }

        @Override
        public boolean isStrictlyOver(Enum<?> left, Enum<?> right) {
            return false;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StandardEnumType)) {
                return false;
            }
            StandardEnumType o = (StandardEnumType)other;
            return this.valueClass.equals(o.valueClass);
        }

        public int hashCode() {
            return this.valueClass.hashCode();
        }
    }
}

