/*
 * Decompiled with CFR 0.152.
 */
package cdc.enums;

import cdc.enums.AbstractBaseDagSupport;
import cdc.enums.DagEventType;
import cdc.enums.DagFeature;
import cdc.enums.DynamicEnumSupport;
import cdc.util.lang.Checks;
import java.util.function.Predicate;

public abstract class AbstractDynamicEnumSupport<V>
extends AbstractBaseDagSupport<V>
implements DynamicEnumSupport<V> {
    private boolean locked = false;
    protected final Predicate<String> nameValidator;
    public static final Predicate<String> DEFAULT_NAME_VALIDATOR = s -> s != null && !s.isEmpty();

    protected AbstractDynamicEnumSupport(Class<V> cls, Predicate<String> nameValidator, DagFeature ... features) {
        super(cls, features);
        Checks.isNotNull(nameValidator, (String)"nameValidator");
        this.nameValidator = nameValidator;
    }

    @Override
    public final boolean isLocked() {
        return this.locked;
    }

    @Override
    public void lock() {
        if (!this.locked) {
            this.locked = true;
            this.fire(null, DagEventType.LOCKED);
        }
    }

    protected final void checkNameIsValid(String name) {
        if (!this.nameValidator.test(name)) {
            throw new IllegalArgumentException("Invalid name '" + name + "'");
        }
    }

    protected final void checkIsUnlocked() {
        if (this.isLocked()) {
            throw new IllegalStateException(this.getValueClass().getCanonicalName() + " is locked");
        }
    }

    protected final void checkHasNoSiblingNamed(V value, String name) {
        if (this.hasSiblingNamed(value, name)) {
            throw new IllegalArgumentException("A sibling named '" + name + "' exists");
        }
    }
}

