/*
 * Decompiled with CFR 0.152.
 */
package cdc.enums;

import cdc.enums.DagType;
import cdc.util.lang.FailureReaction;
import java.util.Comparator;
import java.util.Objects;

public interface EnumType<V>
extends DagType<V> {
    default public V getChildNamed(V value, String name) {
        for (V child : this.getChildren(value)) {
            if (!Objects.equals(this.getName(child), name)) continue;
            return child;
        }
        return null;
    }

    default public boolean hasChildNamed(V value, String name) {
        return this.getChildNamed(value, name) != null;
    }

    default public boolean hasSiblingNamed(V value, String name) {
        if (this.isRoot(value)) {
            for (Object root : this.getRoots()) {
                if (root == value || !Objects.equals(this.getName(root), name)) continue;
                return true;
            }
            return false;
        }
        for (V parent : this.getParents(value)) {
            V matching = this.getChildNamed(parent, name);
            if (matching == null || matching == value) continue;
            return true;
        }
        return false;
    }

    public String getName(V var1);

    public String getQName(V var1);

    public V valueOf(String var1, FailureReaction var2);

    default public V valueOf(String qname) {
        return this.valueOf(qname, FailureReaction.FAIL);
    }

    default public boolean hasValue(String qname) {
        return this.valueOf(qname, FailureReaction.DEFAULT) != null;
    }

    public static String unknownQName(String qname) {
        return "Unknown qname '" + qname + "'";
    }

    public static <V> Comparator<V> createQNameComparator(EnumType<V> enumType) {
        return (o1, o2) -> {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return enumType.getQName(o1).compareTo(enumType.getQName(o2));
        };
    }
}

