/*
 * Decompiled with CFR 0.152.
 */
package cdc.enums;

import cdc.enums.EnumTypes;
import cdc.enums.ListType;
import cdc.enums.Mask;
import cdc.enums.Nullable;
import cdc.enums.SynthesisMask;
import cdc.enums.SynthesisMaskSupport;
import cdc.enums.SynthesisStatus;
import cdc.util.lang.Checks;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public abstract class AbstractSynthesisMask<M extends AbstractSynthesisMask<M, V>, V>
implements SynthesisMask<M, V> {
    protected final SynthesisMaskSupport<M, V> support;
    protected final Map<V, SynthesisStatus> map;

    protected AbstractSynthesisMask(SynthesisMaskSupport<M, V> support, Map<V, SynthesisStatus> map) {
        Checks.isNotNull(support, (String)"support");
        this.support = support;
        this.map = Collections.unmodifiableMap(map);
    }

    public static <M extends AbstractSynthesisMask<M, V>, V> SynthesisMaskSupport<M, V> support(Class<M> maskClass, Creator<M, V> creator, ListType<V> type, Nullable nullable) {
        Checks.isNotNull(maskClass, (String)"maskClass");
        Checks.isNotNull(creator, (String)"creator");
        Checks.isNotNull(type, (String)"type");
        Checks.isNotNull((Object)((Object)nullable), (String)"nullable");
        return new SupportImpl<M, V>(maskClass, creator, type, nullable);
    }

    protected static <M extends AbstractSynthesisMask<M, V>, V extends Enum<V>> SynthesisMaskSupport<M, V> support(Class<M> maskClass, Creator<M, V> creator, Class<V> enumClass, Nullable nullable) {
        Checks.isNotNull(maskClass, (String)"maskClass");
        Checks.isNotNull(creator, (String)"creator");
        Checks.isNotNull(enumClass, (String)"enumClass");
        Checks.isNotNull((Object)((Object)nullable), (String)"nullable");
        return AbstractSynthesisMask.support(maskClass, creator, EnumTypes.getEnumType(enumClass), nullable);
    }

    @Override
    public final SynthesisMaskSupport<M, V> getSupport() {
        return this.support;
    }

    @Override
    public ListType<V> getType() {
        return this.support.getType();
    }

    @Override
    public boolean isNullable() {
        return this.support.isNullable();
    }

    @Override
    public M set(V value, SynthesisStatus status) {
        HashMap<V, SynthesisStatus> tmp = new HashMap<V, SynthesisStatus>();
        tmp.putAll(this.map);
        if (status == SynthesisStatus.UNDEFINED) {
            tmp.remove(value);
        } else {
            tmp.put(value, status);
        }
        return (M)((AbstractSynthesisMask)this.support.create(tmp));
    }

    @Override
    public M setAll(SynthesisStatus status) {
        HashMap<V, SynthesisStatus> tmp = new HashMap<V, SynthesisStatus>();
        if (status != SynthesisStatus.UNDEFINED) {
            for (V value : this.getType().getValues()) {
                tmp.put(value, status);
            }
            if (this.isNullable()) {
                tmp.put(null, status);
            }
        }
        return (M)((AbstractSynthesisMask)this.support.create(tmp));
    }

    @Override
    public SynthesisStatus get(V value) {
        return this.map.getOrDefault(value, SynthesisStatus.UNDEFINED);
    }

    @Override
    public M merge(M other) {
        SynthesisStatus status;
        HashMap<V, SynthesisStatus> tmp = new HashMap<V, SynthesisStatus>();
        for (V value : this.getType().getValues()) {
            SynthesisStatus status2 = this.get(value).merge(((AbstractSynthesisMask)other).get(value));
            if (status2 == SynthesisStatus.UNDEFINED) continue;
            tmp.put(value, status2);
        }
        if (this.isNullable() && (status = this.get(null).merge(((AbstractSynthesisMask)other).get(null))) != SynthesisStatus.UNDEFINED) {
            tmp.put(null, status);
        }
        return (M)((AbstractSynthesisMask)this.support.create(tmp));
    }

    @Override
    public M merge(Mask<?, V> mask) {
        return (M)this.merge((M)((AbstractSynthesisMask)this.support.create(mask)));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!this.support.getSynthesisMaskClass().isInstance(other)) {
            return false;
        }
        AbstractSynthesisMask o = (AbstractSynthesisMask)this.support.getSynthesisMaskClass().cast(other);
        return this.support.getType().equals(o.support.getType()) && this.support.isNullable() == o.support.isNullable() && this.map.equals(o.map);
    }

    public int hashCode() {
        return this.support.getType().hashCode() + (this.support.isNullable() ? 1 : 0) + this.map.hashCode();
    }

    @Override
    public String toString(Function<SynthesisStatus, String> statusToString, String separator) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (V value : this.getSupport().getType().getValues()) {
            if (first) {
                first = false;
            } else {
                builder.append(separator);
            }
            builder.append(statusToString.apply(this.get(value)));
        }
        if (this.isNullable()) {
            if (!first) {
                builder.append(separator);
            }
            builder.append(statusToString.apply(this.get(null)));
        }
        return builder.toString();
    }

    public String toString() {
        return this.toString(Enum::name, "|");
    }

    private static final class SupportImpl<M extends AbstractSynthesisMask<M, V>, V>
    implements SynthesisMaskSupport<M, V> {
        public final Class<M> cls;
        private final Creator<M, V> creator;
        private final ListType<V> type;
        private final Nullable nullable;

        public SupportImpl(Class<M> cls, Creator<M, V> creator, ListType<V> type, Nullable nullable) {
            this.cls = cls;
            this.creator = creator;
            this.type = type;
            this.nullable = nullable;
        }

        @Override
        public Class<M> getSynthesisMaskClass() {
            return this.cls;
        }

        @Override
        public ListType<V> getType() {
            return this.type;
        }

        @Override
        public boolean isNullable() {
            return this.nullable == Nullable.TRUE;
        }

        @Override
        public M create() {
            return this.creator.create(this, Collections.emptyMap());
        }

        @Override
        public M create(Map<V, SynthesisStatus> map) {
            return this.creator.create(this, map);
        }

        @Override
        public M create(SynthesisStatus status) {
            HashMap<V, SynthesisStatus> tmp = new HashMap<V, SynthesisStatus>();
            if (status != SynthesisStatus.UNDEFINED) {
                for (V value : this.getType().getValues()) {
                    tmp.put(value, status);
                }
                if (this.isNullable()) {
                    tmp.put(null, status);
                }
            }
            return this.creator.create(this, tmp);
        }

        @Override
        public M create(Mask<?, V> mask) {
            HashMap<V, SynthesisStatus> tmp = new HashMap<V, SynthesisStatus>();
            for (V value : this.getType().getValues()) {
                tmp.put(value, SynthesisStatus.NONE);
            }
            if (this.isNullable()) {
                tmp.put(null, SynthesisStatus.NONE);
            }
            for (V value : mask.getValues()) {
                tmp.put(value, SynthesisStatus.ALL);
            }
            return this.creator.create(this, tmp);
        }
    }

    @FunctionalInterface
    protected static interface Creator<M extends AbstractSynthesisMask<M, V>, V> {
        public M create(SynthesisMaskSupport<M, V> var1, Map<V, SynthesisStatus> var2);
    }
}

