/*
 * Decompiled with CFR 0.152.
 */
package cdc.enums;

import cdc.enums.AbstractMask;
import cdc.enums.MaskSupport;
import cdc.enums.Nullable;
import cdc.util.lang.Introspection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class EnumMask<E extends Enum<E>>
extends AbstractMask<EnumMask<E>, E> {
    private static final Map<Class<? extends Enum<?>>, MaskSupport<?, ?>> MAP = new HashMap();

    private EnumMask(MaskSupport<EnumMask<E>, E> support, Set<E> values) {
        super(support, values);
    }

    private static <E extends Enum<E>> MaskSupport<EnumMask<E>, E> newSupport(Class<E> enumClass) {
        Class maskClass = Introspection.uncheckedCast(EnumMask.class);
        AbstractMask.Creator creator = EnumMask::new;
        return EnumMask.support(maskClass, creator, enumClass, Nullable.FALSE);
    }

    public static <E extends Enum<E>> MaskSupport<EnumMask<E>, E> support(Class<E> enumClass) {
        MaskSupport tmp;
        MaskSupport result = tmp = MAP.computeIfAbsent(enumClass, k -> EnumMask.newSupport(enumClass));
        return result;
    }

    public static Set<Class<? extends Enum<?>>> getEnumClasses() {
        return MAP.keySet();
    }

    public static <E extends Enum<E>> EnumMask<E> empty(Class<E> enumClass) {
        return EnumMask.support(enumClass).empty();
    }

    public static <E extends Enum<E>> EnumMask<E> full(Class<E> enumClass) {
        return EnumMask.support(enumClass).full();
    }
}

