/*
 * Decompiled with CFR 0.152.
 */
package cdc.enums;

import cdc.args.Args;
import cdc.args.FormalArg;
import cdc.args.FormalArgs;
import cdc.args.Necessity;
import cdc.converters.Converter;
import cdc.converters.defaults.AbstractSequenceToString;
import cdc.enums.Mask;
import cdc.enums.MaskSupport;
import cdc.util.lang.Introspection;
import java.util.ArrayList;
import java.util.function.Function;

public class MaskToString<M extends Mask<M, V>, V>
extends AbstractSequenceToString<M> {
    private final MaskSupport<M, V> support;
    private final Converter<? super V, String> converter;
    public static final FormalArg<MaskSupport<?, ?>> SUPPORT = new FormalArg("support", Introspection.uncheckedCast(MaskSupport.class), Necessity.MANDATORY);
    public static final FormalArg<Converter<?, String>> CONVERTER = new FormalArg("converter", Introspection.uncheckedCast(Converter.class), Necessity.MANDATORY);
    public static final FormalArgs FPARAMS = new FormalArgs(new FormalArg[]{PREFIX, SEPARATOR, SUFFIX, SUPPORT, CONVERTER});

    public MaskToString(MaskSupport<M, V> maskSupport, String prefix, String separator, String suffix, Converter<? super V, String> converter) {
        super(maskSupport.getMaskClass(), prefix, separator, suffix);
        this.support = maskSupport;
        this.converter = converter;
    }

    public final MaskSupport<M, V> getMaskSupport() {
        return this.support;
    }

    public final Converter<? super V, String> getConverter() {
        return this.converter;
    }

    public String apply(M mask) {
        ArrayList<V> list = new ArrayList<V>();
        for (V value : this.support.getType().getValues()) {
            if (!mask.getValues().contains(value)) continue;
            list.add(value);
        }
        return this.toString((Function)this.converter, list);
    }

    public Args getParams() {
        return Args.builder().arg(PREFIX, (Object)this.getPrefix()).arg(SEPARATOR, (Object)this.getSeparator()).arg(SUFFIX, (Object)this.getSuffix()).arg(SUPPORT, this.getMaskSupport()).arg(CONVERTER, this.getConverter()).build();
    }
}

