/*
 * Decompiled with CFR 0.152.
 */
package cdc.enums;

import cdc.enums.AbstractForestDynamicEnum;
import cdc.enums.DagFeature;
import cdc.util.lang.NotFoundException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class AbstractForestDynamicEnumTest {
    private static final Logger LOGGER = LogManager.getLogger(AbstractForestDynamicEnumTest.class);
    private static final String A = "A";
    private static final String AA = "A/A";
    private static final String AB = "A/B";
    private static final String B = "B";
    private static final String BA = "B/A";
    private static final String BB = "B/B";

    AbstractForestDynamicEnumTest() {
    }

    @BeforeAll
    static void init() {
        Enum1.SUPPORT.addEventHandler(e -> LOGGER.debug((Object)e));
        Enum2.SUPPORT.addEventHandler(e -> LOGGER.debug((Object)e));
        Enum1.SUPPORT.findOrCreate(AA);
        Enum1.SUPPORT.findOrCreate(AB);
        Enum1.SUPPORT.findOrCreate(BA);
        Enum1.SUPPORT.findOrCreate(BB);
        Enum2.SUPPORT.findOrCreate(A);
        Enum2.SUPPORT.findOrCreate(B);
    }

    @Test
    void testValid() {
        Assertions.assertEquals((Object)A, (Object)((Enum1)((Object)Enum1.SUPPORT.valueOf(A))).getName());
        Assertions.assertEquals((Object)B, (Object)((Enum1)((Object)Enum1.SUPPORT.valueOf(B))).getName());
        Assertions.assertEquals((Object)AA, (Object)((Enum1)((Object)Enum1.SUPPORT.valueOf(AA))).getQName());
        Assertions.assertEquals((Object)AB, (Object)((Enum1)((Object)Enum1.SUPPORT.valueOf(AB))).getQName());
    }

    void testInvalidValueOf() {
        Assertions.assertThrows(NotFoundException.class, () -> Enum1.SUPPORT.valueOf("C"));
    }

    @Test
    void testEquals() {
        Assertions.assertEquals((Object)Enum1.SUPPORT.valueOf(A), (Object)Enum1.SUPPORT.valueOf(A));
        Assertions.assertEquals((Object)Enum1.SUPPORT.valueOf(AA), (Object)Enum1.SUPPORT.valueOf(AA));
        Assertions.assertNotEquals((Object)Enum1.SUPPORT.valueOf(A), (Object)Enum1.SUPPORT.valueOf(B));
    }

    @Test
    void testRemove() {
        Assertions.assertEquals((int)6, (int)Enum1.SUPPORT.getValues().size());
        Enum1.SUPPORT.findOrCreate("C/A");
        Enum1.SUPPORT.findOrCreate("C/B");
        Enum1.SUPPORT.findOrCreate("C/C");
        Assertions.assertEquals((int)10, (int)Enum1.SUPPORT.getValues().size());
        Assertions.assertEquals((int)3, (int)Enum1.SUPPORT.getRoots().size());
        Enum1.SUPPORT.remove((Object)((Enum1)((Object)Enum1.SUPPORT.findOrCreate("C/C"))));
        Assertions.assertEquals((int)9, (int)Enum1.SUPPORT.getValues().size());
        Assertions.assertEquals((int)3, (int)Enum1.SUPPORT.getRoots().size());
        Enum1.SUPPORT.remove((Object)((Enum1)((Object)Enum1.SUPPORT.findOrCreate("C"))));
        Assertions.assertEquals((int)6, (int)Enum1.SUPPORT.getValues().size());
        Assertions.assertEquals((int)2, (int)Enum1.SUPPORT.getRoots().size());
    }

    @Test
    void testRename() {
        Enum1 a = (Enum1)((Object)Enum1.SUPPORT.findOrCreate(A));
        Enum1 aa = (Enum1)((Object)Enum1.SUPPORT.findOrCreate(AA));
        Enum1 ab = (Enum1)((Object)Enum1.SUPPORT.findOrCreate(AB));
        Enum1.SUPPORT.setName((Object)a, "a");
        Assertions.assertEquals((Object)"a", (Object)a.getName());
        Assertions.assertEquals((Object)A, (Object)aa.getName());
        Assertions.assertEquals((Object)B, (Object)ab.getName());
        Assertions.assertEquals((Object)"a/A", (Object)aa.getQName());
        Assertions.assertEquals((Object)"a/B", (Object)ab.getQName());
    }

    static class Enum1
    extends AbstractForestDynamicEnum<Enum1> {
        static final AbstractForestDynamicEnum.Support<Enum1> SUPPORT = Enum1.support(Enum1.class, Enum1::new, (DagFeature[])new DagFeature[]{DagFeature.REMOVAL, DagFeature.CONTENT_CHANGE});

        protected Enum1(Enum1 parent, String name) {
            super((AbstractForestDynamicEnum)parent, name);
        }
    }

    static class Enum2
    extends AbstractForestDynamicEnum<Enum2> {
        static final AbstractForestDynamicEnum.Support<Enum2> SUPPORT = Enum2.support(Enum2.class, Enum2::new, (DagFeature[])new DagFeature[0]);

        protected Enum2(Enum2 parent, String name) {
            super((AbstractForestDynamicEnum)parent, name);
        }
    }
}

