/*
 * Decompiled with CFR 0.152.
 */
package cdc.enums;

import cdc.enums.AbstractListDynamicEnum;
import cdc.enums.DagFeature;
import cdc.util.lang.NotFoundException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class AbstractListDynamicEnumTest {
    private static final Logger LOGGER = LogManager.getLogger(AbstractListDynamicEnumTest.class);
    private static final String A = "A";
    private static final String B = "B";
    private static final String D = "D";

    AbstractListDynamicEnumTest() {
    }

    @BeforeAll
    static void init() {
        Enum1.SUPPORT.addEventHandler(e -> LOGGER.debug((Object)e));
        Enum2.SUPPORT.addEventHandler(e -> LOGGER.debug((Object)e));
        Enum1.SUPPORT.findOrCreate(A);
        Enum1.SUPPORT.findOrCreate(B);
        Enum2.SUPPORT.findOrCreate(A);
        Enum2.SUPPORT.findOrCreate(B);
        Enum3.SUPPORT1.findOrCreate(A);
        Enum3.SUPPORT2.findOrCreate(A);
        Enum3.SUPPORT2.findOrCreate(B);
    }

    @Test
    void testValid() {
        Assertions.assertEquals((Object)A, (Object)((Enum1)((Object)Enum1.SUPPORT.valueOf(A))).getName());
        Assertions.assertEquals((Object)B, (Object)((Enum1)((Object)Enum1.SUPPORT.valueOf(B))).getName());
    }

    void testInvalidValueOf() {
        Assertions.assertThrows(NotFoundException.class, () -> Enum1.SUPPORT.valueOf("C"));
    }

    @Test
    void testEquals() {
        Assertions.assertEquals((Object)Enum1.SUPPORT.valueOf(A), (Object)Enum1.SUPPORT.valueOf(A));
        Assertions.assertEquals((Object)Enum1.SUPPORT.valueOf(B), (Object)Enum1.SUPPORT.valueOf(B));
        Assertions.assertNotEquals((Object)Enum1.SUPPORT.valueOf(A), (Object)Enum1.SUPPORT.valueOf(B));
    }

    @Test
    void testRemove() {
        Assertions.assertEquals((int)2, (int)Enum2.SUPPORT.getValues().size());
        Enum2 value = (Enum2)((Object)Enum2.SUPPORT.findOrCreate(D));
        Assertions.assertEquals((int)3, (int)Enum2.SUPPORT.getValues().size());
        Enum2.SUPPORT.remove((Object)value);
        Assertions.assertEquals((int)2, (int)Enum2.SUPPORT.getValues().size());
        Assertions.assertFalse((boolean)Enum2.SUPPORT.isValid((Object)value));
    }

    @Test
    void testRename() {
        Enum2 value = (Enum2)((Object)Enum2.SUPPORT.valueOf(A));
        Enum2.SUPPORT.setName((Object)value, "a");
        Assertions.assertEquals((Object)"a", (Object)value.getName());
    }

    @Test
    void testMultiSupport() {
        Enum3 va1 = (Enum3)((Object)Enum3.SUPPORT1.valueOf(A));
        Enum3 va2 = (Enum3)((Object)Enum3.SUPPORT2.valueOf(A));
        Assertions.assertNotEquals((Object)((Object)va1), (Object)((Object)va2));
        Assertions.assertEquals((int)1, (int)Enum3.SUPPORT1.getValues().size());
        Assertions.assertEquals((int)2, (int)Enum3.SUPPORT2.getValues().size());
    }

    static class Enum1
    extends AbstractListDynamicEnum<Enum1> {
        static final AbstractListDynamicEnum.Support<Enum1> SUPPORT = Enum1.support(Enum1.class, Enum1::new, (DagFeature[])new DagFeature[0]);

        protected Enum1(String name) {
            super(name);
        }
    }

    static class Enum2
    extends AbstractListDynamicEnum<Enum2> {
        static final AbstractListDynamicEnum.Support<Enum2> SUPPORT = Enum2.support(Enum2.class, Enum2::new, (DagFeature[])new DagFeature[]{DagFeature.REMOVAL, DagFeature.CONTENT_CHANGE});

        protected Enum2(String name) {
            super(name);
        }
    }

    static class Enum3
    extends AbstractListDynamicEnum<Enum3> {
        static final AbstractListDynamicEnum.Support<Enum3> SUPPORT1 = Enum3.support(Enum3.class, Enum3::new, (DagFeature[])new DagFeature[]{DagFeature.REMOVAL, DagFeature.CONTENT_CHANGE});
        static final AbstractListDynamicEnum.Support<Enum3> SUPPORT2 = Enum3.support(Enum3.class, Enum3::new, (DagFeature[])new DagFeature[]{DagFeature.REMOVAL, DagFeature.CONTENT_CHANGE});

        protected Enum3(String name) {
            super(name);
        }
    }
}

