/*
 * Decompiled with CFR 0.152.
 */
package cdc.enums;

import cdc.enums.AbstractMask;
import cdc.enums.EnumTypes;
import cdc.enums.MaskSupport;
import cdc.enums.Nullable;
import cdc.util.function.Evaluation;
import java.util.HashSet;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class EnumMasksTest {
    EnumMasksTest() {
    }

    @Test
    void testEmptyMask() {
        EvaluationMask maskF = (EvaluationMask)EvaluationMask.SUPPORT.empty();
        Assertions.assertTrue((boolean)maskF.isEmpty());
        Assertions.assertEquals((Object)maskF.empty(), (Object)((Object)maskF));
        NullableEvaluationMask maskT = (NullableEvaluationMask)NullableEvaluationMask.SUPPORT.empty();
        Assertions.assertTrue((boolean)maskT.isEmpty());
        Assertions.assertEquals((Object)maskT.empty(), (Object)((Object)maskT));
    }

    @Test
    void testFullMask() {
        EvaluationMask maskF = (EvaluationMask)EvaluationMask.SUPPORT.full();
        Assertions.assertTrue((boolean)maskF.isFull());
        Assertions.assertEquals((Object)maskF.full(), (Object)((Object)maskF));
        NullableEvaluationMask maskT = (NullableEvaluationMask)NullableEvaluationMask.SUPPORT.full();
        Assertions.assertTrue((boolean)maskT.isFull());
        Assertions.assertEquals((Object)maskT.full(), (Object)((Object)maskT));
    }

    @Test
    void testConstructorBoolean() {
        EvaluationMask maskTrue = (EvaluationMask)EvaluationMask.SUPPORT.create(true);
        for (Evaluation value : Evaluation.values()) {
            Assertions.assertTrue((boolean)maskTrue.isSet(value));
        }
        Assertions.assertEquals((Object)EnumTypes.getEnumType(Evaluation.class), (Object)maskTrue.getSupport().getType());
        EvaluationMask maskFalse = (EvaluationMask)EvaluationMask.SUPPORT.create(false);
        for (Evaluation value : Evaluation.values()) {
            Assertions.assertFalse((boolean)maskFalse.isSet(value));
        }
    }

    @Test
    void testConstructorVarArg() {
        EvaluationMask mask = (EvaluationMask)EvaluationMask.SUPPORT.create();
        for (Evaluation value : Evaluation.values()) {
            Assertions.assertFalse((boolean)mask.isSet(value));
        }
    }

    @Test
    void testConstructorPredicate() {
        EvaluationMask mask = (EvaluationMask)EvaluationMask.SUPPORT.create(e -> true);
        for (Evaluation value : Evaluation.values()) {
            Assertions.assertTrue((boolean)mask.isSet(value));
        }
    }

    @Test
    void testConstructorIterable() {
        HashSet<Evaluation> values = new HashSet<Evaluation>();
        values.add(Evaluation.CONTINUE);
        values.add(null);
        NullableEvaluationMask mask = (NullableEvaluationMask)NullableEvaluationMask.SUPPORT.create(values);
        for (Evaluation value : Evaluation.values()) {
            Assertions.assertEquals((Object)values.contains(value), (Object)mask.isSet(value));
        }
        Assertions.assertEquals(values, (Object)mask.getValues());
    }

    @Test
    void testSet() {
        EvaluationMask mask0 = (EvaluationMask)EvaluationMask.SUPPORT.create();
        Assertions.assertEquals((Object)((Object)mask0), (Object)((Object)mask0));
        Assertions.assertNotEquals((Object)((Object)mask0), (Object)"Hello");
        EvaluationMask mask1 = (EvaluationMask)mask0.set(Evaluation.CONTINUE);
        Assertions.assertTrue((boolean)mask1.isSet(Evaluation.CONTINUE));
        Assertions.assertFalse((boolean)mask1.isSet(Evaluation.PRUNE));
        Assertions.assertNotEquals((Object)((Object)mask0), (Object)((Object)mask1));
        EvaluationMask mask2 = (EvaluationMask)mask1.set(Evaluation.PRUNE);
        Assertions.assertTrue((boolean)mask2.isSet(Evaluation.CONTINUE));
        Assertions.assertTrue((boolean)mask2.isSet(Evaluation.PRUNE));
        EvaluationMask mask3 = (EvaluationMask)mask2.set(Evaluation.PRUNE);
        Assertions.assertTrue((boolean)mask3.isSet(Evaluation.CONTINUE));
        Assertions.assertTrue((boolean)mask3.isSet(Evaluation.PRUNE));
    }

    @Test
    void testClear() {
        EvaluationMask mask0 = (EvaluationMask)EvaluationMask.SUPPORT.create(true);
        EvaluationMask mask1 = (EvaluationMask)mask0.clear(Evaluation.CONTINUE);
        Assertions.assertFalse((boolean)mask1.isSet(Evaluation.CONTINUE));
        Assertions.assertTrue((boolean)mask1.isSet(Evaluation.PRUNE));
        EvaluationMask mask2 = (EvaluationMask)mask1.clear(Evaluation.CONTINUE);
        Assertions.assertFalse((boolean)mask2.isSet(Evaluation.CONTINUE));
        Assertions.assertTrue((boolean)mask2.isSet(Evaluation.PRUNE));
        Assertions.assertEquals((Object)((Object)mask1), (Object)((Object)mask2));
    }

    @Test
    void testAnd() {
        EvaluationMask all = (EvaluationMask)EvaluationMask.SUPPORT.create(true);
        EvaluationMask none = (EvaluationMask)EvaluationMask.SUPPORT.create(false);
        Assertions.assertEquals((Object)((Object)all), (Object)all.and(all));
        Assertions.assertEquals((Object)((Object)none), (Object)all.and(none));
        Assertions.assertEquals((Object)((Object)none), (Object)none.and(all));
        Assertions.assertEquals((Object)((Object)none), (Object)none.and(none));
    }

    @Test
    void testOr() {
        EvaluationMask all = (EvaluationMask)EvaluationMask.SUPPORT.create(true);
        EvaluationMask none = (EvaluationMask)EvaluationMask.SUPPORT.create(false);
        Assertions.assertEquals((Object)((Object)all), (Object)all.or(all));
        Assertions.assertEquals((Object)((Object)all), (Object)all.or(none));
        Assertions.assertEquals((Object)((Object)all), (Object)none.or(all));
        Assertions.assertEquals((Object)((Object)none), (Object)none.or(none));
    }

    @Test
    void testNot() {
        NullableEvaluationMask fullT = (NullableEvaluationMask)NullableEvaluationMask.SUPPORT.create(true);
        NullableEvaluationMask emptyT = (NullableEvaluationMask)NullableEvaluationMask.SUPPORT.create(false);
        Assertions.assertEquals((Object)((Object)emptyT), (Object)fullT.not());
        Assertions.assertEquals((Object)((Object)fullT), (Object)emptyT.not());
        EvaluationMask fullF = (EvaluationMask)EvaluationMask.SUPPORT.create(true);
        EvaluationMask emptyF = (EvaluationMask)EvaluationMask.SUPPORT.create(false);
        Assertions.assertEquals((Object)((Object)emptyF), (Object)fullF.not());
        Assertions.assertEquals((Object)((Object)fullF), (Object)emptyF.not());
    }

    @Test
    void testToString() {
        NullableEvaluationMask fullT = (NullableEvaluationMask)NullableEvaluationMask.SUPPORT.create(true);
        Assertions.assertEquals((Object)"CONTINUE|PRUNE|null", (Object)fullT.toString());
        EvaluationMask fullF = (EvaluationMask)EvaluationMask.SUPPORT.create(true);
        Assertions.assertEquals((Object)"CONTINUE|PRUNE", (Object)fullF.toString());
    }

    @Test
    void testContains() {
        NullableEvaluationMask emptyT = (NullableEvaluationMask)NullableEvaluationMask.SUPPORT.create(false);
        NullableEvaluationMask fullT = (NullableEvaluationMask)NullableEvaluationMask.SUPPORT.create(true);
        Assertions.assertTrue((boolean)fullT.contains(emptyT));
    }

    private static class EvaluationMask
    extends AbstractMask<EvaluationMask, Evaluation> {
        static final MaskSupport<EvaluationMask, Evaluation> SUPPORT = EvaluationMask.support(EvaluationMask.class, EvaluationMask::new, Evaluation.class, (Nullable)Nullable.FALSE);

        private EvaluationMask(MaskSupport<EvaluationMask, Evaluation> support, Set<Evaluation> values) {
            super(support, values);
        }
    }

    private static class NullableEvaluationMask
    extends AbstractMask<NullableEvaluationMask, Evaluation> {
        static final MaskSupport<NullableEvaluationMask, Evaluation> SUPPORT = NullableEvaluationMask.support(NullableEvaluationMask.class, NullableEvaluationMask::new, Evaluation.class, (Nullable)Nullable.TRUE);

        private NullableEvaluationMask(MaskSupport<NullableEvaluationMask, Evaluation> support, Set<Evaluation> values) {
            super(support, values);
        }
    }
}

