/*
 * Decompiled with CFR 0.152.
 */
package cdc.enums;

import cdc.enums.AbstractDynamicEnumSupport;
import cdc.enums.DagEventType;
import cdc.enums.DagFeature;
import cdc.enums.DynamicEnumSupport;
import cdc.enums.EnumType;
import cdc.enums.ForestDynamicEnum;
import cdc.util.lang.Checks;
import cdc.util.lang.FailureReaction;
import cdc.util.lang.ImplementationException;
import cdc.util.lang.NotFoundException;
import cdc.util.lang.Operators;
import cdc.util.lang.UnexpectedValueException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.logging.log4j.Logger;

public abstract class AbstractForestDynamicEnum<V extends AbstractForestDynamicEnum<V>>
implements ForestDynamicEnum<V>,
Comparable<V> {
    private String name;
    private String qname;
    private V parent;
    final List<V> children = new ArrayList<V>();
    public static final char SEPARATOR = '/';

    protected AbstractForestDynamicEnum(V parent, String name) {
        Checks.isNotNullOrEmpty((String)name, (String)"name");
        this.parent = parent;
        this.name = name;
        if (parent == null) {
            this.qname = name;
        } else {
            AbstractForestDynamicEnum tmp = this;
            ((AbstractForestDynamicEnum)parent).children.add(tmp);
            this.qname = ((AbstractForestDynamicEnum)parent).getQName() + "/" + name;
        }
    }

    protected final void setParent(V parent) {
        this.parent = parent;
    }

    @Override
    public final V getParent() {
        return this.parent;
    }

    @Override
    public final List<V> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    protected final void setName(String name) {
        this.name = name;
        this.qname = this.parent == null ? name : ((AbstractForestDynamicEnum)this.parent).getQName() + "/" + name;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getQName() {
        return this.qname;
    }

    public String toString() {
        return this.getQName();
    }

    public int hashCode() {
        return this.getQName().hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int compareTo(V o) {
        return this.getQName().compareTo(((AbstractForestDynamicEnum)o).getQName());
    }

    public static <V extends ForestDynamicEnum<V>> Support<V> support(Class<V> cls, Predicate<String> nameValidator, Creator<V> creator, Modifier<V> modifier, DagFeature ... features) {
        Checks.isNotNull(cls, (String)"cls");
        Checks.isNotNull(nameValidator, (String)"nameValidator");
        Checks.isNotNull(creator, (String)"creator");
        return new SupportImpl<V>(cls, nameValidator, creator, modifier, features);
    }

    protected static <V extends AbstractForestDynamicEnum<V>> Support<V> support(Class<V> cls, Predicate<String> nameValidator, Creator<V> creator, DagFeature ... features) {
        Checks.isNotNull(cls, (String)"cls");
        Checks.isNotNull(nameValidator, (String)"nameValidator");
        Checks.isNotNull(creator, (String)"creator");
        Modifier modifier = new Modifier<V>(){

            @Override
            public void setName(V value, String name) {
                ((AbstractForestDynamicEnum)value).setName(name);
            }

            @Override
            public void setParent(V value, V parent) {
                ((AbstractForestDynamicEnum)value).setParent(parent);
            }

            @Override
            public void addChild(V value, V child) {
                ((AbstractForestDynamicEnum)value).children.add(child);
            }

            @Override
            public void removeChild(V value, V child) {
                ((AbstractForestDynamicEnum)value).children.remove(child);
            }
        };
        return AbstractForestDynamicEnum.support(cls, nameValidator, creator, modifier, features);
    }

    protected static <V extends AbstractForestDynamicEnum<V>> Support<V> support(Class<V> cls, Creator<V> creator, DagFeature ... features) {
        Checks.isNotNull(cls, (String)"cls");
        Checks.isNotNull(creator, (String)"creator");
        return AbstractForestDynamicEnum.support(cls, AbstractDynamicEnumSupport.DEFAULT_NAME_VALIDATOR, creator, features);
    }

    private static final class SupportImpl<V extends ForestDynamicEnum<V>>
    extends AbstractDynamicEnumSupport<V>
    implements Support<V> {
        private final List<V> roots = new ArrayList<V>();
        private final List<V> validValues = new ArrayList<V>();
        private final Map<String, V> qnameToValue = new HashMap<String, V>();
        private final Creator<V> creator;
        private final Modifier<V> modifier;
        private static final Predicate<DagFeature> POSSIBLE_FEATURES = e -> {
            switch (e) {
                case CREATION: 
                case LOCKING: 
                case REMOVAL: 
                case CONTENT_CHANGE: 
                case REPARENTING: {
                    return true;
                }
            }
            throw new UnexpectedValueException((Enum)e);
        };
        private final Consumer<V> refreshQName;

        protected SupportImpl(Class<V> cls, Predicate<String> nameValidator, Creator<V> creator, Modifier<V> modifier, DagFeature ... features) {
            super(cls, nameValidator, (DagFeature[])Checks.areAccepted(POSSIBLE_FEATURES, (String)"features", (Object[])features));
            this.creator = creator;
            this.modifier = modifier;
            if (modifier == null) {
                for (DagFeature feature : features) {
                    if (feature != DagFeature.CONTENT_CHANGE && feature != DagFeature.REPARENTING) continue;
                    throw new IllegalArgumentException("Unexpected feature " + feature);
                }
            }
            this.refreshQName = v -> {
                this.qnameToValue.remove(v.getQName());
                modifier.setName(v, v.getName());
                this.qnameToValue.put(v.getQName(), (ForestDynamicEnum)v);
            };
        }

        @Override
        protected boolean isContained(V value) {
            return this.validValues.contains(value);
        }

        @Override
        public List<V> getValues() {
            return Collections.unmodifiableList(this.validValues);
        }

        @Override
        public String getName(V value) {
            return value == null ? null : value.getName();
        }

        @Override
        public String getQName(V value) {
            return value == null ? null : value.getQName();
        }

        @Override
        public List<V> getRoots() {
            return Collections.unmodifiableList(this.roots);
        }

        @Override
        public List<V> getChildren(V value) {
            return value.getChildren();
        }

        @Override
        public List<V> getParents(V value) {
            return value.getParent() == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(value.getParent()));
        }

        @Override
        public V valueOf(String qname, FailureReaction reaction) {
            return (V)((ForestDynamicEnum)NotFoundException.onResult((Object)((ForestDynamicEnum)this.qnameToValue.get(qname)), (String)EnumType.unknownQName(qname), (Logger)this.logger, (FailureReaction)reaction, null));
        }

        @Override
        public V findOrCreate(String qname) {
            Object value = (ForestDynamicEnum)this.qnameToValue.get(qname);
            if (value == null) {
                String name;
                Object parent;
                this.checkIsUnlocked();
                int pos = qname.lastIndexOf(47);
                if (pos < 0) {
                    parent = null;
                    name = qname;
                } else {
                    parent = this.findOrCreate(qname.substring(0, pos));
                    name = qname.substring(pos + 1);
                }
                this.checkNameIsValid(name);
                value = this.creator.create(parent, name);
                if (!name.equals(value.getName()) || value.getParent() != parent) {
                    throw new ImplementationException(this.getValueClass().getCanonicalName() + " Unexpected name '" + value.getName() + "' under '" + (ForestDynamicEnum)parent + "'");
                }
                this.qnameToValue.put(qname, value);
                this.validValues.add(value);
                if (parent == null) {
                    this.roots.add(value);
                }
                this.fire(value, DagEventType.CREATED);
            }
            return (V)value;
        }

        @Override
        public V findOrCreate(V parent, String path) {
            if (parent == null) {
                return (V)this.findOrCreate(path);
            }
            return (V)this.findOrCreate(parent.getQName() + "/" + path);
        }

        @Override
        public void setParent(V value, V parent) {
            this.checkIsValid(value);
            this.checkIsUnlocked();
            this.checkIsSupported(DagFeature.REPARENTING);
            this.checkIsNotOverOrEqual(value, parent);
            if (value.getParent() != parent) {
                if (value.getParent() != null) {
                    this.modifier.removeChild(value.getParent(), value);
                } else {
                    this.roots.remove(value);
                }
                this.modifier.setParent(value, parent);
                if (parent == null) {
                    this.roots.add(value);
                } else {
                    this.modifier.addChild(parent, value);
                }
                this.iterateUnder(value, this.refreshQName);
                this.fire(value, DagEventType.REPARENTED);
            }
        }

        @Override
        public void remove(V value) {
            this.checkIsValid(value);
            this.checkIsUnlocked();
            this.checkIsSupported(DagFeature.REMOVAL);
            while (!value.getChildren().isEmpty()) {
                ForestDynamicEnum last = (ForestDynamicEnum)value.getChildren().get(value.getChildren().size() - 1);
                this.remove((V)last);
            }
            if (value.getParent() != null) {
                this.modifier.removeChild(value.getParent(), value);
            } else {
                this.roots.remove(value);
            }
            this.validValues.remove(value);
            this.qnameToValue.remove(value.getQName());
            this.fire(value, DagEventType.REMOVED);
        }

        @Override
        public void setName(V value, String name) {
            this.checkIsValid(value);
            this.checkIsUnlocked();
            this.checkIsSupported(DagFeature.CONTENT_CHANGE);
            this.checkNameIsValid(name);
            this.checkHasNoSiblingNamed(value, name);
            if (!value.getName().equals(name)) {
                this.qnameToValue.remove(value.getQName());
                this.modifier.setName(value, name);
                this.qnameToValue.put(value.getQName(), value);
                for (ForestDynamicEnum child : value.getChildren()) {
                    this.iterateUnder(child, this.refreshQName);
                }
                this.fire(value, DagEventType.CONTENT_CHANGED);
            }
        }

        @Override
        public boolean isValid(V value) {
            return value != null && this.qnameToValue.containsKey(value.getQName());
        }

        @Override
        public boolean areEqual(V left, V right) {
            return Operators.equals(left, right);
        }

        @Override
        public boolean isStrictlyOver(V left, V right) {
            return left != null && right != null && left.isStrictlyOver(right);
        }
    }

    @FunctionalInterface
    public static interface Creator<V extends ForestDynamicEnum<V>> {
        public V create(V var1, String var2);
    }

    public static interface Modifier<V extends ForestDynamicEnum<V>> {
        public void setName(V var1, String var2);

        public void setParent(V var1, V var2);

        public void addChild(V var1, V var2);

        public void removeChild(V var1, V var2);
    }

    public static interface Support<V extends ForestDynamicEnum<V>>
    extends DynamicEnumSupport<V> {
        public V findOrCreate(V var1, String var2);

        public void setParent(V var1, V var2);
    }
}

