/*
 * Decompiled with CFR 0.152.
 */
package cdc.enums;

import cdc.enums.AbstractDynamicEnumSupport;
import cdc.enums.DagEventType;
import cdc.enums.DagFeature;
import cdc.enums.DynamicEnumSupport;
import cdc.enums.EnumType;
import cdc.enums.ListDynamicEnum;
import cdc.util.lang.Checks;
import cdc.util.lang.FailureReaction;
import cdc.util.lang.ImplementationException;
import cdc.util.lang.NotFoundException;
import cdc.util.lang.Operators;
import cdc.util.lang.UnexpectedValueException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.logging.log4j.Logger;

public abstract class AbstractListDynamicEnum<V extends AbstractListDynamicEnum<V>>
implements ListDynamicEnum<V>,
Comparable<V> {
    private String name;

    protected AbstractListDynamicEnum(String name) {
        Checks.isNotNullOrEmpty((String)name, (String)"name");
        this.name = name;
    }

    protected final void setName(String name) {
        this.name = name;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public String getQName() {
        return this.getName();
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int compareTo(V o) {
        return this.name.compareTo(((AbstractListDynamicEnum)o).getName());
    }

    public static <E extends ListDynamicEnum<E>> Support<E> support(Class<E> cls, Predicate<String> nameValidator, Creator<E> creator, Modifier<E> modifier, DagFeature ... features) {
        Checks.isNotNull(cls, (String)"cls");
        Checks.isNotNull(nameValidator, (String)"nameValidator");
        Checks.isNotNull(creator, (String)"creator");
        return new SupportImpl<E>(cls, nameValidator, creator, modifier, features);
    }

    protected static <E extends AbstractListDynamicEnum<E>> Support<E> support(Class<E> cls, Predicate<String> nameValidator, Creator<E> creator, DagFeature ... features) {
        Checks.isNotNull(cls, (String)"cls");
        Checks.isNotNull(nameValidator, (String)"nameValidator");
        Checks.isNotNull(creator, (String)"creator");
        Modifier<AbstractListDynamicEnum> modifier = (value, name) -> value.setName(name);
        return AbstractListDynamicEnum.support(cls, nameValidator, creator, modifier, features);
    }

    protected static <E extends AbstractListDynamicEnum<E>> Support<E> support(Class<E> cls, Creator<E> creator, DagFeature ... features) {
        Checks.isNotNull(cls, (String)"cls");
        Checks.isNotNull(creator, (String)"creator");
        return AbstractListDynamicEnum.support(cls, AbstractDynamicEnumSupport.DEFAULT_NAME_VALIDATOR, creator, features);
    }

    private static final class SupportImpl<V extends ListDynamicEnum<V>>
    extends AbstractDynamicEnumSupport<V>
    implements Support<V> {
        private final List<V> validValues = new ArrayList<V>();
        private final Map<String, V> nameToValue = new HashMap<String, V>();
        private final Creator<V> creator;
        private final Modifier<V> modifier;
        private static final Predicate<DagFeature> POSSIBLE_FEATURES = e -> {
            switch (e) {
                case CREATION: 
                case LOCKING: 
                case REMOVAL: 
                case CONTENT_CHANGE: {
                    return true;
                }
                case REPARENTING: {
                    return false;
                }
            }
            throw new UnexpectedValueException((Enum)e);
        };

        public SupportImpl(Class<V> cls, Predicate<String> nameValidator, Creator<V> creator, Modifier<V> modifier, DagFeature ... features) {
            super(cls, nameValidator, (DagFeature[])Checks.areAccepted(POSSIBLE_FEATURES, (String)"features", (Object[])features));
            this.creator = creator;
            this.modifier = modifier;
            if (modifier == null) {
                for (DagFeature feature : features) {
                    if (feature != DagFeature.CONTENT_CHANGE) continue;
                    throw new IllegalArgumentException("Unexpected feature " + feature);
                }
            }
        }

        @Override
        protected boolean isContained(V value) {
            return this.validValues.contains(value);
        }

        @Override
        public List<V> getValues() {
            return Collections.unmodifiableList(this.validValues);
        }

        @Override
        public List<V> getRoots() {
            return this.getValues();
        }

        @Override
        public List<V> getChildren(V value) {
            Checks.isNotNull(value, (String)"value");
            return Collections.emptyList();
        }

        @Override
        public List<V> getParents(V value) {
            Checks.isNotNull(value, (String)"value");
            return Collections.emptyList();
        }

        @Override
        public String getName(V value) {
            return value == null ? null : value.getName();
        }

        @Override
        public String getQName(V value) {
            return this.getName(value);
        }

        @Override
        public V valueOf(String qname, FailureReaction reaction) {
            return (V)((ListDynamicEnum)NotFoundException.onResult((Object)((ListDynamicEnum)this.nameToValue.get(qname)), (String)EnumType.unknownQName(qname), (Logger)this.logger, (FailureReaction)reaction, null));
        }

        @Override
        public V findOrCreate(String qname) {
            ListDynamicEnum value = (ListDynamicEnum)this.nameToValue.get(qname);
            if (value == null) {
                this.checkIsUnlocked();
                this.checkNameIsValid(qname);
                this.checkIsSupported(DagFeature.CREATION);
                value = this.creator.create(qname);
                if (!qname.equals(value.getName())) {
                    throw new ImplementationException("Unexpected name: '" + value.getName() + "'");
                }
                this.nameToValue.put(qname, value);
                this.validValues.add(value);
                this.fire(value, DagEventType.CREATED);
            }
            return (V)value;
        }

        @Override
        public void remove(V value) {
            this.checkIsValid(value);
            this.checkIsUnlocked();
            this.checkIsSupported(DagFeature.REMOVAL);
            this.validValues.remove(value);
            this.nameToValue.remove(value.getName());
            this.fire(value, DagEventType.REMOVED);
        }

        @Override
        public void setName(V value, String name) {
            this.checkIsValid(value);
            this.checkIsUnlocked();
            this.checkIsSupported(DagFeature.CONTENT_CHANGE);
            this.checkNameIsValid(name);
            this.checkHasNoSiblingNamed(value, name);
            if (!value.getName().equals(name)) {
                this.nameToValue.remove(value.getName());
                this.modifier.setName(value, name);
                this.nameToValue.put(name, value);
                this.fire(value, DagEventType.CONTENT_CHANGED);
            }
        }

        @Override
        public boolean isValid(V value) {
            return value != null && this.nameToValue.containsKey(value.getName());
        }

        @Override
        public boolean areEqual(V left, V right) {
            return Operators.equals(left, right);
        }

        @Override
        public boolean isStrictlyOver(V left, V right) {
            return false;
        }
    }

    @FunctionalInterface
    public static interface Creator<V extends ListDynamicEnum<V>> {
        public V create(String var1);
    }

    @FunctionalInterface
    public static interface Modifier<V extends ListDynamicEnum<V>> {
        public void setName(V var1, String var2);
    }

    public static interface Support<V extends ListDynamicEnum<V>>
    extends DynamicEnumSupport<V> {
    }
}

